package com.artfess.cgpt.material.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.material.model.PlatMaterial;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 *  服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
public interface BizMaterialCategoryManager extends BaseManager<BizMaterialCategory> {

    List<BizMaterialCategory> selectTree();


    PageList<BizMaterialCategory> queryAllByPage(QueryFilter<BizMaterialCategory> queryFilter);

    /**
     * 查询企业授权物料分类树结构
     * @return
     */
    List<BizMaterialCategory> getEnterpriseCategoryTree();

    /**
     * 查询企业授权物料分类树结构
     * @param companyCode 企业编号
     * @return
     */
    List<BizMaterialCategory> getEnterpriseCategoryTree(String companyCode);

    void exportExcelData(QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(BizMaterialCategory entity);

    /**
     * 保存或更新数据
     * @param entity
     */
    void updateYqcCategory(BizMaterialCategory entity);

    /**
     * 保存或更新数据（api）
     * @param param
     */
    Response saveOrUpdateByApi(JSONObject param);

    /**
     * 根据id集合修改状态
     * @param ids id集合
     * @param status 状态（0：禁用，1：启用）
     */
    void updateStatus(List<String> ids,String status);

}
