package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.material.manager.ProductManager;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.model.Product;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:产品管理表
 * @Author: Rong Tao
 * @Date: 2024/8/12 15:11
 */
@RestController
@RequestMapping("/product/v1/")
@Api(tags="产品管理表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProductController extends BaseController<ProductManager, Product> {

    @Autowired
    UCFeignService ucFeignService;

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<Product>> queryByPage(@RequestBody QueryFilter<Product> queryFilter){
        String orgId = ContextUtil.getCurrentOrgId();
        if(BeanUtils.isEmpty(orgId)){
            return new CommonResult<>(true,"查询成功",new PageList<>(new ArrayList<Product>()));
        }
        queryFilter.addFilter("ORG_ID_",orgId, QueryOP.EQUAL);

        PageList<Product> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<Product>> queryAllByPage(@RequestBody QueryFilter<Product> queryFilter){
        PageList<Product> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody Product entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-根据id修改状态")
    public CommonResult updateStatus(@RequestParam("ids") String ids,@RequestParam("status") String status){
        if(BeanUtils.isEmpty(ids)){
            return new CommonResult<>(false,"请选择数据");
        }
        if(BeanUtils.isEmpty(status)){
            return new CommonResult<>(false,"请传入状态");
        }
        baseService.updateStatusByIds(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    @PostMapping("/removeByIds")
    @ApiOperation(value = "M-根据id批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            return new CommonResult<>(false,"请选择数据");
        }
        baseService.removeData(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询")
    public CommonResult getDataById(@RequestParam("id") String id){
        if(BeanUtils.isEmpty(id)){
            return new CommonResult<>(false,"请选择数据");
        }
        Product result = baseService.getDataById(id);
        return new CommonResult<>(true,"操作成功",result);
    }

}
