package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Description:平台物料库
 * @Author: Rong Tao
 * @Date: 2024/7/25 18:34
 */
@RestController
@RequestMapping("/platMaterial/v1/")
@Api(tags="平台物料库")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PlatMaterialController extends BaseController<PlatMaterialManager,PlatMaterial> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<PlatMaterial>> queryByPage(@RequestBody QueryFilter<PlatMaterial> queryFilter){
        PageList<PlatMaterial> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping(value = "/updateMatStatus")
    @ApiOperation(value = "M-修改物料状态")
    public CommonResult updateMatStatus(@RequestBody List<String> ids, @RequestParam String status) {
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            throw new BaseException("请选择物料");
        }
        baseService.updateMatStatus(ids,status);
        return new CommonResult<>(true, "操作成功",ids);
    }

    @PostMapping(value = "/updateMatCategory")
    @ApiOperation(value = "M-根据id集合修改物料分类")
    public CommonResult updateMatCategory(@RequestBody List<String> ids, @RequestParam String categoryCode) {
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            throw new BaseException("请选择物料");
        }
        baseService.updateMatCategory(ids,categoryCode);
        return new CommonResult<>(true, "操作成功",ids);
    }

    @PostMapping("/exportExcelData")
    @ApiOperation(value = "M-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportExcelData(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<PlatMaterial> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportExcelData(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

}
