package com.artfess.cgpt.foreignApi.vo;

import lombok.Data;

/**
 * @Description: 微信公告模版
 * @Author: Rong Tao
 * @Date: 2023/4/23 18:00
 */
@Data
public class WxNoticeTemplate {
    private String token;
    private String openId;

    /**
     * 用户账号（指定用户，为空则推送所有人）
     */
    private String userAccount;
    /**
     * 模版id
     */
    private String templateId;
    /**
     * 服务单号:公告名称
     */
    private String keyword1;
    /**
     * 服务主题:需求企业
     */
    private String keyword2;
    /**
     * 服务状态:招标类型
     */
    private String keyword3;
    /**
     * 处理时间:发布时间
     */
    private String keyword4;
    /**
     * 详情链接url
     */
    private String url;
    /**
     * 备注
     */
    private String remark;

    public WxNoticeTemplate() {
    }

    public WxNoticeTemplate(String keyword1, String keyword2, String keyword3, String keyword4, String url, String remark) {
        this.keyword1 = keyword1;
        this.keyword2 = keyword2;
        this.keyword3 = keyword3;
        this.keyword4 = keyword4;
        this.url = url;
        this.remark = remark;
    }

    public WxNoticeTemplate(String keyword1, String keyword2, String keyword3, String keyword4, String url) {
        this.keyword1 = keyword1;
        this.keyword2 = keyword2;
        this.keyword3 = keyword3;
        this.keyword4 = keyword4;
        this.url = url;
    }

    public WxNoticeTemplate(String keyword1, String keyword2, String keyword3, String keyword4) {
        this.keyword1 = keyword1;
        this.keyword2 = keyword2;
        this.keyword3 = keyword3;
        this.keyword4 = keyword4;
    }

}
