package com.artfess.cgpt.foreignApi.vo;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.string.StringPool;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.OperateLogUtil;
import com.artfess.uc.util.UpdateCompare;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Email;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 用户vo
 * @Author: Rong Tao
 * @Date: 2022/12/6 15:18
 */

@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class BizUserVo implements UpdateCompare{

    @ApiModelProperty(name = "id", notes = "用户id")
    private String id;

    @ApiModelProperty(name = "companyCode", notes = "企业编号", required = true)
    private String companyCode;

    @ApiModelProperty(name = "account", notes = "登录帐号（更新时不会更新）", required = true)
    private String account;

    @ApiModelProperty(name = "fullname", notes = "用户名", required = true)
    private String fullname;

    @ApiModelProperty(name = "userNumber", notes = "工号", required = true)
    private String userNumber;


    @ApiModelProperty(name = "roleList", notes = "角色集合")
    private List<String> roleList;


    @ApiModelProperty(name = "password", notes = "登录密码（更新时不会更新）", required = true)
    private String password;

    @ApiModelProperty(name = "email", notes = "邮箱地址")
    @Email(message="{valid.com.artfess.Email} {valid.com.artfess.Email.message}")
    private String email;

    @ApiModelProperty(name = "mobile", notes = "手机号码")
    private String mobile;

    @ApiModelProperty(name = "systemCode", notes = "业务系统编码（可访问的业务系统编码）")
    private String systemCode;

//    @ApiModelProperty(name = "weixin", notes = "微信")
//    private String weixin;

//    @ApiModelProperty(name = "address", notes = "地址")
//    private String address;

//    @ApiModelProperty(name = "sex", notes = "性别", allowableValues = "男,女,未知")
//    private String sex;

//    @ApiModelProperty(name = "photo", notes = "头像（更新时不会更新）", allowableValues = "用户的头像")
//    protected String photo;

    @ApiModelProperty(name = "status", notes = "状态 1：正常；0：禁用；-1：待激活；-2：离职（默认为正常）")
    private Integer status;

//    @ApiModelProperty(name = "idCard", notes = "身份证号")
//    private String idCard;

//    @ApiModelProperty(name = "phone", notes = "办公电话")
//    private String phone;


//    @ApiModelProperty(name = "updateTime", notes = "更新时间")
//    private LocalDateTime updateTime;

    @ApiModelProperty(name = "isDelete", notes = "是否已删除 1已删除 0未删除（更新时不会更新）")
    private String isDelete;

//    @ApiModelProperty(name = "version", notes = "版本号（更新时不会更新）")
//    private Integer version;

//    @ApiModelProperty(name = "from", notes = "来源")
//    private String from;

//    @ApiModelProperty(name = "params", notes = "用户参数（获取单个用户时才会有值）")
//    private Map<String, Object> params;

    @ApiModelProperty(name="tenantId",notes="租户id")
    protected String tenantId;

//    @ApiModelProperty(name="clientId",notes="推送服务令牌（设备唯一标识）")
//    protected String clientId;

//    @ApiModelProperty(name="clientToken",notes="设备令牌（iOS设备唯一标识）")
//    protected String clientToken;

//    @ApiModelProperty(name = "lockedTime", notes = "锁定时间")
//    protected LocalDateTime lockedTime;

    @ApiModelProperty(name = "lockedStatus", notes = "锁定状态（1：正常 2：已锁定）")
    protected Integer lockedStatus;

    @ApiModelProperty(name = "userType", notes = "人员类型（0：超级管理员 1：管理账号 2：普通账号  ）")
    protected Integer userType;

    @ApiModelProperty(name = "lastLoginTime", notes = "最后登录时间")
    protected LocalDateTime lastLoginTime;

    @ApiModelProperty(name = "bizUserType", notes = "业务人员类型（0：业务 1：合同 2：财务，3：开票）")
    protected String bizUserType;


    @Override
    public String compare() throws Exception {
        UserManager service = AppUtil.getBean(UserManager.class);
        User oldVo = service.getByAccount(this.account);
        UserVo newVo = new UserVo();
        BeanUtils.copyNotNullProperties(newVo,this);
        newVo.setVersion(null);
        newVo.setParams(null);
        return OperateLogUtil.compare(newVo, changeVo(oldVo));
    }

    public static UserVo changeVo(User oldVo) {
        UserVo newVo = new UserVo();
        if (BeanUtils.isEmpty(oldVo))
            return newVo;
        newVo.setAccount(oldVo.getAccount());
        newVo.setAddress(oldVo.getAddress());
        newVo.setBirthday(DateFormatUtil.format(oldVo.getBirthday().atStartOfDay(), StringPool.DATE_FORMAT_DATE));
        newVo.setEducation(oldVo.getEducation());
        newVo.setEmail(oldVo.getEmail());
        newVo.setEntryDate(DateFormatUtil.format(oldVo.getEntryDate().atStartOfDay(), StringPool.DATE_FORMAT_DATE));
        newVo.setLeaveDate(oldVo.getLeaveDate());
        newVo.setFrom(oldVo.getFrom());
        newVo.setFullname(oldVo.getFullname());
        newVo.setIdCard(oldVo.getIdCard());
        newVo.setIsDelete(oldVo.getIsDelete());
        newVo.setMobile(oldVo.getMobile());
        newVo.setPhone(oldVo.getPhone());
        newVo.setPhoto(oldVo.getPhoto());
        newVo.setSex(oldVo.getSex());
        newVo.setStatus(oldVo.getStatus());
        newVo.setUpdateTime(oldVo.getUpdateTime());
        newVo.setUserNumber(oldVo.getUserNumber());
        newVo.setTenantId(oldVo.getTenantId());
        newVo.setUserType(oldVo.getUserType());
        newVo.setLockedStatus(oldVo.getLockedStatus());
        newVo.setLockedTime(oldVo.getLockedTime());
        newVo.setLastLoginTime(oldVo.getLastLoginTime());
        return newVo;
    }
}
