package com.artfess.cgpt.foreignApi.service;

import cn.hutool.json.JSONObject;
import com.artfess.base.model.CommonResult;
import com.artfess.cgpt.foreignApi.vo.BizUserVo;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.foreignApi.vo.PushNoticeVO;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserVo;

import java.util.List;

/**
 * @Description:对外接口调用
 * @Author: Rong Tao
 * @Date: 2023/8/10 10:53
 */
public interface ForeignCallService {

    /**
     * 调用外部接口
     * @param url 接口地址
     * @param params 参数
     * @param sys 调用系统：1.主数据，2.支付平台
     * @return
     */
    void callForeignInterface(String url,Object params,Integer sys);

    /**
     * 调用外部接口
     * @param url 接口地址
     * @param params 参数
     * @param sys 调用系统：1.主数据，2.支付平台
     * @return
     */
    void callForeignInterfaceResponse(String url,Object params,Integer sys);

    /**
     * 调用外部接口
     * @param url 接口地址
     * @param params 参数
     * @param sys 调用系统：1.主数据，2.支付平台
     * @return 0：成功，1：失败
     */
    JSONObject callInterfaceResponse(String url, JSONObject params, Integer sys);

    /**
     * 调用外部接口
     * @param url 接口地址
     * @param params 参数
     * @param sys 调用系统：1.主数据，2.支付平台
     * @return 0：成功，1：失败
     */
    ForeignResponseVo callInterface(String url, JSONObject params, Integer sys);

    /**
     * 调用支付平台支付接口
     * @param trans 支付记录
     * @param type 类型：1.内部，2.外部
     * @return
     */
    ForeignResponseVo callPay(TransVo trans, Integer type);

    /**
     * 调用支付平台支付接口
     * @param transList 支付记录集合
     * @param type 类型：1.内部，2.外部
     * @return
     */
//    ForeignResponseVo callPay(List<TransactionDetails> transList, Integer type);

    /**
     * 推送对账单
     * @param recVO 对账单
     * @return
     */
//    JSONObject pushRec(RecVO recVO);

    /**
     * 创建tokenKey并存入redis
     * @return tokenKey
     */
    String createTokenKey();

    /**
     * 校验tokenKey并返回token
     * @param tokenKey
     * @return token
     */
    CommonResult checkToken(String tokenKey);

    /**
     * 根据token获取用户信息
     * @param
     * @return
     */
    CommonResult<BizUserVo> getUserByTOKEN();

    /**
     * 流程前置事件，推送待办到门户网站（流程接口未使用）
     * @param instId 流程实例ID
     */
    void pushTaskToMh(String instId) throws Exception;

    /**
     * 流程后置事件，推送已办到门户网站（流程接口）
     * @param instId 流程实例ID
     */
    void completeTaskToMh(String instId);

    /**
     * 流程前置事件，生成待办任务到门户（流程接口）
     * @param taskId 流程任务ID
     */
    void pushTaskToMhByTaskId(String taskId) throws Exception;

    /**
     * 推送中选公示到门户
     * @param detailedList 招标明细
     * @return
     */
//    void pushSucBidNotice(List<BizHandleNoticeDetailed> detailedList);

    /**
     * 推送招标公告到门户
     * @param mhNoticeVO 招标公告
     * @return
     */
    void pushNoticeToMh(PushNoticeVO mhNoticeVO);

    /**
     * 推送微信公众号消息
     * @param wxNoticeTemplate
     * @return
     */
    JSONObject pushWxMessage(WxNoticeTemplate wxNoticeTemplate);

    /**
     * 获取主数据用户信息
     * @param queryVO
     * @return
     */
    JSONObject queryUser(User queryVO);

    /**
     * 推送主数据用户信息
     * @param param
     * @return
     */
    JSONObject pushUser(UserVo param);

}
