package com.artfess.cgpt.evaluation.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.evaluation.model.BizEvaluationItem;
import com.artfess.cgpt.evaluation.dao.BizEvaluationItemDao;
import com.artfess.cgpt.evaluation.manager.BizEvaluationItemManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 评标项目表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizEvaluationItemManagerImpl extends BaseManagerImpl<BizEvaluationItemDao, BizEvaluationItem> implements BizEvaluationItemManager {
    @Override
    public PageList<BizEvaluationItem> queryAllByPage(QueryFilter<BizEvaluationItem> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizEvaluationItem> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public List<BizEvaluationItem> selectTree() {
        List<BizEvaluationItem> categories = baseMapper.queryAll1();
//        List<Category> collect = categories.stream().filter(category -> category.getId().equals("0")).collect(Collectors.toList());需要根节点
        List<BizEvaluationItem> collect = categories.stream().filter(BizEvaluationItem -> BizEvaluationItem.getPcode().equals("0")).collect(Collectors.toList());
        for (BizEvaluationItem c : collect) {
            c.setChildren(getchildren(c, categories));
        }
        return collect;
    }

    private List<BizEvaluationItem> getchildren(BizEvaluationItem root, List<BizEvaluationItem> list) {
        List<BizEvaluationItem> children = list.stream().filter(BizEvaluationItem -> BizEvaluationItem.getPcode().equals(root.getId())
        ).collect(Collectors.toList());
        if (children != null && children.size() > 0) {
            for (BizEvaluationItem c : children) {
                c.setChildren(getchildren(c, list));
            }
        }
        return children;
    }
}
