package com.artfess.cgpt.evaluation.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;

/**
 * 评标体系明细表，只有综合评标法有明细，最低价评标法无明细 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizEvaluationSystemDescription/v1/")
@Api(tags="评标体系明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEvaluationSystemDescriptionController extends BaseController<BizEvaluationSystemDescriptionManager, BizEvaluationSystemDescription> {

    @PostMapping("/getEvaScore")
    @ApiOperation(value = "M-查询数据（评分联查）")
    public CommonResult<BizEvaluationSystem> getEvaScore(@RequestBody BizEvaluationSystemDescription param) {
        BizEvaluationSystem result = baseService.getEvaScore(param);
        return new CommonResult<>(true, "查询成功", result);
    }

}
