package com.artfess.cgpt.evaluation.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemUseOrgManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemUseOrg;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;

import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.List;

/**
 * 评标体系表，综合评标法/最低价评标法都用此表，综合评标法有明细，最低价评标法无明细 前端控制器
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizEvaluationSystem/v1/")
@Api(tags = "评标体系表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEvaluationSystemController extends BaseController<BizEvaluationSystemManager, BizEvaluationSystem> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizEvaluationSystem>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizEvaluationSystem> queryFilter) {
        PageList<BizEvaluationSystem> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageDetail")
    @ApiOperation(value = "M-分页查询所有数据（包含明细）")
    public CommonResult<PageList<BizEvaluationSystem>> pageDetail(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizEvaluationSystem> queryFilter) {
        PageList<BizEvaluationSystem> result = baseService.pageDetail(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据（编制单位过滤）")
    public CommonResult<PageList<BizEvaluationSystem>> queryByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizEvaluationSystem> queryFilter) {
        PageList<BizEvaluationSystem> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageByUseOrg")
    @ApiOperation(value = "M-分页查询数据（使用单位过滤）")
    public CommonResult<PageList<BizEvaluationSystem>> queryByUseOrg(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizEvaluationSystem> queryFilter) {
        PageList<BizEvaluationSystem> result = baseService.queryByUseOrg(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-添加或修改评标体系")
    public CommonResult saveSupplierOrg(@RequestBody BizEvaluationSystem entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizEvaluationSystem> selectOne(@RequestParam String id) {
        BizEvaluationSystem result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

}
