package com.artfess.cgpt.contract.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.cgpt.contract.manager.ContractItemManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.dao.BizContractDao;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.contract.model.ContractCallBack;
import com.artfess.cgpt.contract.model.ContractItem;
import com.artfess.cgpt.contract.vo.ContractVo;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.sso.model.SsoSystem;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CategoryService;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.SendContractRequest;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.impl.CategoryServiceImpl;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合同表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@Service
public class BizContractManagerImpl extends BaseManagerImpl<BizContractDao, BizContract> implements BizContractManager {

    private final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Value("${contractSys.serverUrl}")
    private String serverUrl;
    @Value("${contractSys.accessKey}")
    private String accessKey;
    @Value("${contractSys.accessSecret}")
    private String accessSecret;
    @Value("${contractSys.streamId}")
    private Long streamId;
    @Value("${contractSys.taxStreamId}")
    private Long taxStreamId;
//    @Value("${contractSys.TENANT_NAME}")
//    private String TENANT_NAME;
    private CategoryService categoryService;
    private ContractService contractService;

    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ContractItemManager contractItemManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetailManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;

    @Override
    public Integer getNoSignContrCount(String noticeId,String vendorId) {
        Integer count = baseMapper.getNoSignContrCount(noticeId,vendorId);
        return count;
    }

    @Override
    public PageList<BizContract> queryAllByPage(QueryFilter<BizContract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizContract> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizContract> pageVendorGroup(QueryFilter<BizContract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizContract> result = baseMapper.pageVendorGroup(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(BizContract entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<ContractItem> itemList = entity.getItemList();

        if(BeanUtils.isEmpty(entity.getContrCode())){
            entity.setContrCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"htgl_htbh"));
        }
        if(BeanUtils.isEmpty(entity.getVendorTaxNumber())){
            Enterprise vendorEnterprise = enterpriseManager.getByOrgIdOrCode(entity.getVendorId(), entity.getVendorCode());
            if(BeanUtils.isEmpty(vendorEnterprise)){
                throw new BaseException("请先前往主数据推送企业【"+entity.getVendorName()+"】信息");
            }
            if(BeanUtils.isEmpty(vendorEnterprise.getCompanyOrgcode())){
                throw new BaseException("请先前往主数据维护企业【"+entity.getVendorName()+"】税号，并推送到采购平台");
            }

            entity.setVendorTaxNumber(vendorEnterprise.getCompanyOrgcode());
        }
        if(BeanUtils.isEmpty(entity.getGenerType())) {
            entity.setGenerType(1);
        }

        if(BeanUtils.isNotEmpty(entity.getId())){
            LambdaQueryWrapper<ContractItem> contractItemQW = new LambdaQueryWrapper<>();
            contractItemQW.eq(ContractItem::getContractId,entity.getId());
            if(entity.getGenerType()==1){
                List<ContractItem> detailHisList = contractItemManager.list(contractItemQW);
                if(BeanUtils.isNotEmpty(detailHisList) && detailHisList.size()>0){
                    List<String> collect = detailHisList.stream().filter(s -> BeanUtils.isNotEmpty(s.getWinNoticeDetailId()))
                            .map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList());
                    if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                        LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> winDetailUW = new LambdaUpdateWrapper<>();
                        winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus,1)
                                .in(BizWinBiddingNoticeDetaile::getId,collect);
                        winBidNoticeDetailManager.update(winDetailUW);
                    }
                }
            }
            contractItemManager.remove(contractItemQW);

            accessoryService.removeBySourceId(entity.getId());

            if(entity.getIsAgencyProcure()==1 && entity.getGenerType()==1){
                //删除代采合同
                LambdaQueryWrapper<BizContract> agenyContrQW = new LambdaQueryWrapper<>();
                agenyContrQW.eq(BizContract::getAgencyContrctId,entity.getId())
                        .eq(BizContract::getIsDele,"0");
                List<BizContract> agenyContrHisList = super.list(agenyContrQW);
                if(BeanUtils.isNotEmpty(agenyContrHisList) && agenyContrHisList.size()>0){
                    List<String> collect = agenyContrHisList.stream().map(s -> s.getId()).collect(Collectors.toList());
                    accessoryService.removeBySourceIds(collect);
                    LambdaQueryWrapper<ContractItem> agenyItemQW = new LambdaQueryWrapper<>();
                    agenyItemQW.in(ContractItem::getContractId,collect);
                    contractItemManager.remove(agenyItemQW);
                    super.remove(agenyContrQW);
                }
            }

        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

        if(BeanUtils.isNotEmpty(itemList) && itemList.size()>0){
            itemList.forEach(s->s.setContractId(entity.getId()));

            if(entity.getGenerType()==1) {
                List<String> winDetailIds = itemList.stream().filter(s -> BeanUtils.isNotEmpty(s.getWinNoticeDetailId()))
                        .map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(winDetailIds) && winDetailIds.size()>0){
                    LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> winDetailUW = new LambdaUpdateWrapper<>();
                    winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus,2)
                            .in(BizWinBiddingNoticeDetaile::getId,winDetailIds);
                    winBidNoticeDetailManager.update(winDetailUW);
                }
            }

            contractItemManager.saveBatch(itemList);
        }

        if(entity.getIsAgencyProcure()==1 && entity.getGenerType()==1){
            generAgencyProcureContr(entity);
        }

        if(entity.getStatus()==4){
            //提交审核时发起合同草稿
            try {
                createContract(entity.getId());
            } catch (Exception e) {
                System.out.println("创建电子合同草稿失败："+e.getMessage());
                throw new BaseException("创建电子合同草稿失败："+e.getMessage());
            }
        }

        return entity.getId();
    }

    /**
     * 生成代采合同
     * @param source 原合同
     */
    @Transactional
    public void generAgencyProcureContr(BizContract source) {
//        List<Accessory> accessoryList = source.getAccessoryList();
        List<ContractItem> itemList = source.getItemList();
        //查询代采企业
        if(BeanUtils.isEmpty(itemList) || itemList.size()<=0){
            return;
        }

        List<String> purAppIds = itemList.stream().filter(s -> BeanUtils.isNotEmpty(s.getPurchasingApplicationId()))
                .map(s -> s.getPurchasingApplicationId()).collect(Collectors.toList());
        if(BeanUtils.isEmpty(purAppIds) || purAppIds.size()<=0){
            throw new BaseException("未找到代采申请单");
        }
        LambdaQueryWrapper<PurchasingApplication> purAppQW = new LambdaQueryWrapper<>();
        purAppQW.eq(PurchasingApplication::getIsAgencyProcure,1)
                .in(PurchasingApplication::getId,purAppIds)
                .eq(PurchasingApplication::getIsDele,"0");
        List<PurchasingApplication> purchasingApplications = purchasingApplicationManager.list(purAppQW);
        if(BeanUtils.isEmpty(purchasingApplications) || purchasingApplications.size()<=0){
            throw new BaseException("未找到代采申请单");
        }

        Map<String, List<PurchasingApplication>> collect = purchasingApplications.stream().collect(Collectors.groupingBy(PurchasingApplication::getPreparedOrgId));
        collect.forEach((preOrgId,appList)->{
            List<String> collect1 = appList.stream().map(s -> s.getId()).collect(Collectors.toList());
            PurchasingApplication tempData = appList.get(0);
            BizContract agencyContr = new BizContract();
            try {
                BeanUtils.copyNotNullProperties(agencyContr,source);
            } catch (ReflectiveOperationException e) {
                e.printStackTrace();
                throw new BaseException("代采合同转换失败："+e.getMessage());
            }
            agencyContr.setId(null);
            agencyContr.setContrCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"htgl_htbh"));
            agencyContr.setContrName(source.getContrName()+"-"+tempData.getPreparedOrgName()+"代采");
            agencyContr.setMatCompanyId(preOrgId);
            agencyContr.setMatCompanyCode(tempData.getPreparedOrgCode());
            agencyContr.setMatCompanyName(tempData.getPreparedOrgName());
            agencyContr.setMatCompanyUserId(tempData.getPreparedUserId());
            agencyContr.setMatCompanyUserName(tempData.getPreparedUserName());
            User byId = userManager.getById(tempData.getPreparedUserId());
            agencyContr.setMatCompanyUserPhone(byId.getMobile());
            agencyContr.setVendorId(source.getMatCompanyId());
            agencyContr.setVendorCode(source.getMatCompanyCode());
            agencyContr.setVendorName(source.getMatCompanyName());
            Enterprise vendorEnterprise = enterpriseManager.getByOrgIdOrCode(source.getMatCompanyId(), source.getMatCompanyCode());
            if(BeanUtils.isEmpty(vendorEnterprise)){
                throw new BaseException("请先前往主数据推送企业【"+source.getMatCompanyName()+"】信息");
            }
            if(BeanUtils.isEmpty(vendorEnterprise.getCompanyOrgcode())){
                throw new BaseException("请先前往主数据维护企业【"+source.getMatCompanyName()+"】税号，并推送到采购平台");
            }

            agencyContr.setVendorTaxNumber(vendorEnterprise.getCompanyOrgcode());
            agencyContr.setVendorUserId(source.getMatCompanyUserId());
            agencyContr.setVendorUserName(source.getMatCompanyUserName());
            agencyContr.setVendorUserPhone(source.getMatCompanyUserPhone());
            agencyContr.setGenerType(2);
            agencyContr.setIsAgencyProcure(1);
            agencyContr.setAgencyContrctId(source.getId());
            super.save(agencyContr);

            List<ContractItem> tempItems = itemList.stream().filter(s -> collect1.contains(s.getPurchasingApplicationId())).collect(Collectors.toList());
            List<ContractItem> agencyContrDetailList = new ArrayList<>();
            for(ContractItem sourceItem : tempItems){
                ContractItem item = new ContractItem();
                try {
                    BeanUtils.copyNotNullProperties(item,sourceItem);
                } catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    throw new BaseException("代采合同明细转换失败："+e.getMessage());
                }
                item.setId(null);
                item.setContractId(agencyContr.getId());
                agencyContrDetailList.add(item);
            }
            contractItemManager.saveBatch(agencyContrDetailList);

//            if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
//                List<Accessory> accessories = new ArrayList<>();
//                for(Accessory accessory : accessoryList){
//                    Accessory a = new Accessory();
//                    try {
//                        BeanUtils.copyNotNullProperties(a,accessory);
//                    } catch (ReflectiveOperationException e) {
//                        e.printStackTrace();
//                        throw new BaseException("代采合同附件转换失败："+e.getMessage());
//                    }
//                    a.setId(null);
//                    a.setSourceId(agencyContr.getId());
//                    accessories.add(a);
//                }
//                accessoryService.saveBatch(accessories);
//            }

        });

    }

    @Override
    public void saveVo(ContractVo vo) {
        BizContract contract = vo.getBizContract();
        this.saveOrUpdate(contract);
        List<ContractItem> items = vo.getContractItems();


        //全删全寸
        contractItemManager.deleByContractId(contract.getId());

        for (ContractItem item : items) {
            item.setContractId(contract.getId());
        }
        contractItemManager.saveOrUpdateBatch(items);
    }

    @Override
    public BizContract getDetailById(String id) {
        BizContract result = this.getById(id);
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        result.setItemList(contractItemManager.getByContractId(id));
        return result;
    }

    @Override
    @Transactional
    public void removeData(List<String> ids) {
        LambdaQueryWrapper<BizContract> contrQW = new LambdaQueryWrapper<>();
        contrQW.notIn(BizContract::getStatus,Arrays.asList("1,6".split(",")))
                .eq(BizContract::getIsDele,"0")
                .in(BizContract::getId,ids);
        if(super.count(contrQW)>0){
            throw new BaseException("删除失败：仅草稿状态可删除");
        }

        //查询删除合同的所有明细
        LambdaQueryWrapper<ContractItem> contractItemQW = new LambdaQueryWrapper<>();
        contractItemQW.in(ContractItem::getContractId,ids);
        List<ContractItem> detailHisList = contractItemManager.list(contractItemQW);

        if(BeanUtils.isNotEmpty(detailHisList) && detailHisList.size()>0) {
            List<String> collect = detailHisList.stream().filter(s -> BeanUtils.isNotEmpty(s.getWinNoticeDetailId()))
                    .map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(collect) && collect.size() > 0) {
                LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> winDetailUW = new LambdaUpdateWrapper<>();
                winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus, 1)
                        .in(BizWinBiddingNoticeDetaile::getId, collect);
                winBidNoticeDetailManager.update(winDetailUW);
            }
            contractItemManager.remove(contractItemQW);
        }

        //删除代采合同
        LambdaQueryWrapper<BizContract> agenyContrQW = new LambdaQueryWrapper<>();
        agenyContrQW.in(BizContract::getAgencyContrctId,ids)
                .eq(BizContract::getIsDele,"0");
        List<BizContract> agenyContrHisList = super.list(agenyContrQW);
        if(BeanUtils.isNotEmpty(agenyContrHisList) && agenyContrHisList.size()>0){
            List<String> collect = agenyContrHisList.stream().map(s -> s.getId()).collect(Collectors.toList());
            LambdaQueryWrapper<ContractItem> agenyItemQW = new LambdaQueryWrapper<>();
            agenyItemQW.in(ContractItem::getContractId,collect);
            contractItemManager.remove(agenyItemQW);
            super.remove(agenyContrQW);
        }

        super.removeByIds(ids);
        accessoryService.removeBySourceIds(ids);
    }


    @Override
    @Transactional
    public void updateStatusByIds(String ids,String status) {
        List<String> idList = Arrays.asList(ids.split(","));

        if(status.equals("4")){
            //提交审核时发起合同草稿
            for(String id : idList){
                try {
                    createContract(id);
                } catch (Exception e) {
                    System.out.println("创建电子合同草稿失败："+e.getMessage());
                    throw new BaseException("创建电子合同草稿失败："+e.getMessage());
                }
            }
        }
        if(status.equals("5")){
            //已审核，自动发起合同签署
            for(String id : idList){
                BizContract contr = super.getById(id);
                try {
                    sendContract(contr.getThreeContractId());
                } catch (Exception e) {
                    System.out.println("发起合同签署失败："+e.getMessage());
                    throw new BaseException("发起合同签署失败："+e.getMessage());
                }
            }

            status = "2";
        }

        LambdaUpdateWrapper<BizContract> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BizContract::getStatus,status)
                .in(BizContract::getId,idList).eq(BizContract::getIsDele,"0");
        super.update(updateWrapper);

    }


    public void init() {
        SDKClient sdkClient = new SDKClient(serverUrl, accessKey, accessSecret);

        contractService = new ContractServiceImpl(sdkClient);
        categoryService = new CategoryServiceImpl(sdkClient);
    }

    @Override
    public String browseContract(String threeContrId) {
        init();
        //方法调用
        ViewUrlRequest request = new ViewUrlRequest();
        request.setContractId(Long.valueOf(threeContrId));
        request.setPageType(ViewUrlRequest.PageType.CONTENT);
        String viewUrl = null;
        try {
            viewUrl = contractService.viewUrl(request);
        } catch (PrivateAppException e) {
            e.printStackTrace();
        }

        System.out.println("合同查看链接:"+viewUrl);
        return viewUrl;
    }

    @Override
    public void downBatchContract(List<Long> threeContrIds, HttpServletResponse response) {
        init();
        try(
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStream os = response.getOutputStream();
        ) {
            String fileName = URLEncoder.encode("合同文件.zip", "UTF-8");

            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("filename", fileName);

            contractService.batchDownload(threeContrIds, baos);

            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();

//            IOUtils.safeClose(os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    @Override
//    public String createContract(String id) throws Exception {
//        //获取本地合同表数据
//        BizContract localContract = super.getById(id);
//        if(localContract.getStatus()==2 || localContract.getStatus()==3){
//            throw new BaseException("发起失败：当前合同处于签订中或已签订状态");
//        }
//        if(localContract.getStatus()!=5){
//            throw new BaseException("发起失败：已审核状态下才能发起签订");
//        }
//
//        //初始化
//        init();
//
//        Long contrStreamId = taxStreamId;
//
//        List<Long> documentIdList= new ArrayList<>();
//        //获取合同附件
//        List<Accessory> accessory = accessoryService.getAccessoryBySourceId(id);
//        if(BeanUtils.isNotEmpty(accessory) && accessory.size()>0){
//            for(Accessory a: accessory){
//                String url = a.getUrl();
//                //对本地文件命名
////                String fileName = url.substring(url.lastIndexOf("."),url.length());
//                File file = null;
//                URL urlfile;
//                InputStream inStream = null;
//                OutputStream os = null;
//                try {
//                    file = File.createTempFile("net_url", a.getSuffix());
//                    //下载
//                    urlfile = new URL(url);
//                    inStream = urlfile.openStream();
//                    os = new FileOutputStream(file);
//
//                    int bytesRead = 0;
//                    byte[] buffer = new byte[8192];
//                    while ((bytesRead = inStream.read(buffer, 0, 8192)) != -1) {
//                        os.write(buffer, 0, bytesRead);
//                    }
//                } catch (Exception e) {
//                    e.printStackTrace();
//                } finally {
//                    try {
//                        if (null != os) {
//                            os.close();
//                        }
//                        if (null != inStream) {
//                            inStream.close();
//                        }
//
//                    } catch (Exception e) {
//                        e.printStackTrace();
//                    }
//                }
//
//                //为附件创建合同文档
//                CreateDocumentRequest request = new CreateDocumentRequest();
//
//                request.setFile(new StreamFile(new FileInputStream(file)));
////                request.setFile(new StreamFile(new FileInputStream(new File("E:\\OneDrive\\桌面\\artfess\\cs.docx"))));
//                request.setFileType(a.getSuffix());
//                request.setTitle(BeanUtils.isNotEmpty(a.getName())?a.getName():"其他文档");
//                //  request.setTitle("其他文档");
//                CreateDocumentResult result = contractService.createByFile(request);
//                Long documentId = result.getDocumentId();
//                documentIdList.add(documentId);
//            }
//        }
//
//        if(localContract.getIsTax()==2){
//            contrStreamId = streamId;
//        }
//
//        Map<String, String> params = new HashMap<>();
//        // 设置参数：
//        params.put("contrCode", localContract.getContrCode());
//        params.put("vendor", localContract.getVendorName());
//        params.put("vendorSign", localContract.getVendorName());
//        params.put("matCompany", localContract.getMatCompanyName());
//        params.put("matCompanySign", localContract.getMatCompanyName());
//        params.put("signDate", DATE_FORMATTER.format(LocalDate.now()));
//        params.put("startDate", DATE_FORMATTER.format(localContract.getContractStartDate()));
//        params.put("endDate", DATE_FORMATTER.format(localContract.getContractEndDate()));
//        //法人或委托代理人
//        params.put("matCompanyUser", localContract.getMatCompanyUserName());
//        params.put("vendorUser", localContract.getVendorUserName());
//
//        //查询合同明细表信息
//        List<ContractItem> itemList = contractItemManager.getByContractId(id);
//
//        //表格参数
//        List<String> tableList = new ArrayList<String>();
//        if(BeanUtils.isNotEmpty(itemList) && itemList.size()>0){
//            List<DictModel> payMethodDic = sysDictionaryManager.queryDictListItemsByCode("cglx-fkfs");
//
//            for(ContractItem it : itemList){
//                BigDecimal price = it.getTaxInprice();
//                BigDecimal amount = it.getTaxInvalue();
//                String accountPeriod = "";
//                if(localContract.getIsTax()==2){
//                    price = it.getContrPrice();
//                    amount = it.getContrAmount();
//                }
//                if(localContract.getPayMethod()==1){
//                    //现金
//                    if(BeanUtils.isNotEmpty(it.getPendingTime())){
//                        accountPeriod = it.getPendingTime().toString();
//                    }
//                }else if(localContract.getPayMethod()==2){
//                    //承兑
//                    if(BeanUtils.isNotEmpty(it.getAcceptanceTime())){
//                        accountPeriod = it.getAcceptanceTime().toString();
//                    }
//                }
//                tableList.add("{\"c1\":\""+it.getMatPlatcode()+"\",\"c2\":\"" +it.getMatName()
//                        +"\",\"c3\":\"" +(BeanUtils.isNotEmpty(it.getMatSpec())?it.getMatSpec():"")
//                        +"\",\"c4\":\""+(BeanUtils.isNotEmpty(it.getMatMaterial())?it.getMatMaterial():"")
//                        +"\",\"c5\":\"" +it.getNum()+"\",\"c6\":\""+it.getMatUnit()
//                        +"\",\"c7\":\""+price+"\",\"c8\":\""+amount
//                        +"\",\"c9\":\""+BizUtils.getDicCodeByValue(payMethodDic,localContract.getPayMethod().toString())
//                        +"\",\"c10\":\""+accountPeriod
//                        +"\",\"c11\":\""+it.getTaxRate()+"\",\"c12\":\""+it.getTaxValue()
//                        +"\",\"c13\":\""+(BeanUtils.isNotEmpty(it.getPurNote())?it.getPurNote():"")
//                        +"\",\"c14\":\""+(BeanUtils.isNotEmpty(it.getVendorNote())?it.getVendorNote():"")
//                        +"\"}");
//            }
//            String tableParams = tableList.toString();
//            params.put("detailList",tableParams);
//            System.out.println(LocalDateTime.now()+"----签署合同明细列表参数----"+tableParams);
//            log.debug("----签署合同明细列表参数----"+tableParams);
//        }
//
//        CreateContractRequest createContractRequest = new CreateContractRequest();
//        //合同终止时间；格式：yyyy-MM-dd 。时分秒默认为当天的23时59分59秒（不支持修改）。
//        //默认合同结束日期
////        createContractRequest.setEndTime(TimeUtils.format(TimeUtils.after(new Date(), 7), TimeUtils.STANDARD_PATTERN));
//        createContractRequest.setEndTime(DATE_FORMATTER.format(localContract.getContractEndDate()));
//        //是否立即发起合同，默认true。（true：立即发起；false：保存为草稿）
//        createContractRequest.setSend(true);
//        //允许指定位置签署，默认使用业务分类中的「签署位置规则」配置
//        createContractRequest.setMustSign(true);
//        //是否允许在指定的签署位置之外签署，默认使用业务分类中的「签署位置规则」配置
//        createContractRequest.setExtraSign(true);
//        //是否自动生成会签节点 （用于签署动作中传入多个印章并且未指定签署人）默认false
//        createContractRequest.setAutoCreateCounterSign(true);
//        //设置接收方必须签署全部合同文档
//        createContractRequest.setSignAll("RECEIVER");
//        //0 发送全部通知；1 仅发送短信通知；2 仅发送邮件通知
//        createContractRequest.setMsgCode(0);
//
//        //为合同添加其他文档
//        if(documentIdList.size()>0){
//            createContractRequest.setDocuments(documentIdList);
//        }
//
//        //合同名称
//        createContractRequest.setSubject(localContract.getContrName());
//        //合同创建人姓名，不传创建人的相关信息默认为发起方的名称
////        createContractRequest.setCreatorName(localContract.getFirstPartyUserName());
//        //合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
////        createContractRequest.setCreatorContact(localContract.getFirstPartyUserPhone());
//        //发起方名称
////        createContractRequest.setTenantName(localContract.getFirstPartyCompanyName());
//        createContractRequest.setTenantName(localContract.getMatCompanyName());
//
//        //签署方信息
//        List<Signatory> signatories = new ArrayList<Signatory>();
//
//        //转让方
//        Signatory signatory1 = new Signatory();
//        //接收人联系方式：手机号、电子邮箱号（签署方为个人时联系方式（contact）或编号（receiverNumber）至少传递一个）
//        signatory1.setContact(localContract.getVendorUserPhone());
//        //	签署方类型：COMPANY（企业），PERSONAL（个人）
//        signatory1.setTenantType(TenantType.COMPANY);
//        //签署方名称
//        signatory1.setTenantName(localContract.getVendorName());
//        signatory1.setSerialNo(2); // 签署顺序，从1开始
//        //接收人姓名
//        signatory1.setReceiverName(localContract.getVendorUserName());
//
//        //受让方
//        Signatory signatory2 = new Signatory();
//        //接收人联系方式：手机号、电子邮箱号（签署方为个人时联系方式（contact）或编号（receiverNumber）至少传递一个）
//        signatory2.setContact(localContract.getMatCompanyUserPhone());
//        //	签署方类型：COMPANY（企业），PERSONAL（个人）
//        signatory2.setTenantType(TenantType.COMPANY);
//        //签署方名称
//        signatory2.setTenantName(localContract.getMatCompanyName());
//        signatory2.setSerialNo(1); // 签署顺序，从1开始
//        //接收人姓名
//        signatory2.setReceiverName(localContract.getMatCompanyUserName());
//
//        // 添加签署方
//        signatories.add(signatory1);
//        signatories.add(signatory2);
//        createContractRequest.setSignatories(signatories);
//
//        //用印流程id
//        createContractRequest.setCategoryId(contrStreamId);
//
//        //文档参数
//        createContractRequest.setDocumentParams(params);
//
//        Long contractId = null;
//        try {
//            //创建合同
//            contractId = contractService.createContractByCategory(createContractRequest);
//        } catch (PrivateAppException e) {
//            e.printStackTrace();
//        }
//
//        System.out.println("创建合同成功,contractId:"+contractId);
//
//        //本地合同表状态改为签订中【2】
//        localContract.setStatus(2);
//        localContract.setThreeContractId(contractId.toString());
//        super.updateById(localContract);
//
//        //合同浏览页面方法调用
//        ViewUrlRequest request = new ViewUrlRequest();
//        request.setContractId(contractId);
//        request.setPageType(ViewUrlRequest.PageType.CONTENT);
//        String viewUrl = null;
//        try {
//            viewUrl = contractService.viewUrl(request);
//        } catch (PrivateAppException e) {
//            e.printStackTrace();
//        }
//
//        System.out.println("合同查看链接:"+viewUrl);
//        return viewUrl;
//    }

    @Override
    public String createContract(String id) throws Exception {
        //获取本地合同表数据
        BizContract localContract = super.getById(id);
//        if(localContract.getStatus()==2 || localContract.getStatus()==3){
//            throw new BaseException("发起失败：当前合同处于签订中或已签订状态");
//        }
//        if(localContract.getStatus()!=5){
//            throw new BaseException("发起失败：已审核状态下才能发起签订");
//        }

        //初始化
        init();

        Long contrStreamId = taxStreamId;

        List<Long> documentIdList= new ArrayList<>();
        //获取合同附件
        List<Accessory> accessory = accessoryService.getAccessoryBySourceId(id);
        if(BeanUtils.isNotEmpty(accessory) && accessory.size()>0){
            for(Accessory a: accessory){
                String url = a.getUrl();
                //对本地文件命名
//                String fileName = url.substring(url.lastIndexOf("."),url.length());
                File file = null;
                URL urlfile;
                InputStream inStream = null;
                OutputStream os = null;
                try {
                    file = File.createTempFile("net_url", a.getSuffix());
                    //下载
                    urlfile = new URL(url);
                    inStream = urlfile.openStream();
                    os = new FileOutputStream(file);

                    int bytesRead = 0;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inStream.read(buffer, 0, 8192)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    try {
                        if (null != os) {
                            os.close();
                        }
                        if (null != inStream) {
                            inStream.close();
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                //为附件创建合同文档
                CreateDocumentRequest request = new CreateDocumentRequest();

                request.setFile(new StreamFile(new FileInputStream(file)));
//                request.setFile(new StreamFile(new FileInputStream(new File("E:\\OneDrive\\桌面\\artfess\\cs.docx"))));
                request.setFileType(a.getSuffix());
                request.setTitle(BeanUtils.isNotEmpty(a.getName())?a.getName():"其他文档");
                //  request.setTitle("其他文档");
                CreateDocumentResult result = contractService.createByFile(request);
                Long documentId = result.getDocumentId();
                documentIdList.add(documentId);
            }
        }

        if(localContract.getIsTax()==2){
            contrStreamId = streamId;
        }

        Map<String, String> params = new HashMap<>();
        // 设置参数：
        params.put("contrCode", localContract.getContrCode());
        params.put("vendor", localContract.getVendorName());
        params.put("vendorSign", localContract.getVendorName());
        params.put("matCompany", localContract.getMatCompanyName());
        params.put("matCompanySign", localContract.getMatCompanyName());
        params.put("signDate", DATE_FORMATTER.format(LocalDate.now()));
        params.put("startDate", DATE_FORMATTER.format(localContract.getContractStartDate()));
        params.put("endDate", DATE_FORMATTER.format(localContract.getContractEndDate()));
        //法人或委托代理人
        params.put("matCompanyUser", localContract.getMatCompanyClientName());
        params.put("vendorUser", localContract.getVendorUserName());

        //查询合同明细表信息
        List<ContractItem> itemList = contractItemManager.getByContractId(id);

        //表格参数
        List<String> tableList = new ArrayList<String>();
        if(BeanUtils.isNotEmpty(itemList) && itemList.size()>0){
            List<DictModel> payMethodDic = sysDictionaryManager.queryDictListItemsByCode("cglx-fkfs");

            for(ContractItem it : itemList){
                BigDecimal price = it.getTaxInprice();
                BigDecimal amount = it.getTaxInvalue();
                String accountPeriod = "";
                if(localContract.getIsTax()==2){
                    price = it.getContrPrice();
                    amount = it.getContrAmount();
                }
                if(localContract.getPayMethod()==1){
                    //现金
                    if(BeanUtils.isNotEmpty(it.getPendingTime())){
                        accountPeriod = it.getPendingTime().toString();
                    }
                }else if(localContract.getPayMethod()==2){
                    //承兑
                    if(BeanUtils.isNotEmpty(it.getAcceptanceTime())){
                        accountPeriod = it.getAcceptanceTime().toString();
                    }
                }
                tableList.add("{\"c1\":\""+it.getMatPlatcode()+"\",\"c2\":\"" +it.getMatName()
                        +"\",\"c3\":\"" +(BeanUtils.isNotEmpty(it.getMatSpec())?it.getMatSpec():"")
                        +"\",\"c4\":\""+(BeanUtils.isNotEmpty(it.getMatMaterial())?it.getMatMaterial():"")
                        +"\",\"c5\":\"" +it.getNum()+"\",\"c6\":\""+it.getMatUnit()
                        +"\",\"c7\":\""+price+"\",\"c8\":\""+amount
                        +"\",\"c9\":\""+BizUtils.getDicCodeByValue(payMethodDic,localContract.getPayMethod().toString())
                        +"\",\"c10\":\""+accountPeriod
                        +"\",\"c11\":\""+it.getTaxRate()+"\",\"c12\":\""+it.getTaxValue()
                        +"\",\"c13\":\""+(BeanUtils.isNotEmpty(it.getPurNote())?it.getPurNote():"")
                        +"\",\"c14\":\""+(BeanUtils.isNotEmpty(it.getVendorNote())?it.getVendorNote():"")
                        +"\"}");
            }
            String tableParams = tableList.toString();
            params.put("detailList",tableParams);
            System.out.println(LocalDateTime.now()+"----签署合同明细列表参数----"+tableParams);
            log.debug("----签署合同明细列表参数----"+tableParams);
        }

        CreateContractRequest createContractRequest = new CreateContractRequest();
        //合同终止时间；格式：yyyy-MM-dd 。时分秒默认为当天的23时59分59秒（不支持修改）。
        //默认合同结束日期
//        createContractRequest.setEndTime(TimeUtils.format(TimeUtils.after(new Date(), 7), TimeUtils.STANDARD_PATTERN));
        createContractRequest.setEndTime(DATE_FORMATTER.format(localContract.getContractEndDate()));
        //是否立即发起合同，默认true。（true：立即发起；false：保存为草稿）
        createContractRequest.setSend(false);
        //允许指定位置签署，默认使用业务分类中的「签署位置规则」配置
        createContractRequest.setMustSign(true);
        //是否允许在指定的签署位置之外签署，默认使用业务分类中的「签署位置规则」配置
        createContractRequest.setExtraSign(true);
        //是否自动生成会签节点 （用于签署动作中传入多个印章并且未指定签署人）默认false
        createContractRequest.setAutoCreateCounterSign(true);
        //设置接收方必须签署全部合同文档
        createContractRequest.setSignAll("RECEIVER");
        //0 发送全部通知；1 仅发送短信通知；2 仅发送邮件通知
        createContractRequest.setMsgCode(0);

        //为合同添加其他文档
        if(documentIdList.size()>0){
            createContractRequest.setDocuments(documentIdList);
        }

        //合同名称
        createContractRequest.setSubject(localContract.getContrName());
        //合同创建人姓名，不传创建人的相关信息默认为发起方的名称
//        createContractRequest.setCreatorName(localContract.getFirstPartyUserName());
        //合同创建人联系方式，联系方式允许使用大陆、台湾和香港的手机号，台湾和香港的手机号格式为：区号+空格+手机号，例：852 9xxxxxxx
//        createContractRequest.setCreatorContact(localContract.getFirstPartyUserPhone());
        //发起方名称
//        createContractRequest.setTenantName(localContract.getFirstPartyCompanyName());
        createContractRequest.setTenantName(localContract.getMatCompanyName());

        //签署方信息
        List<Signatory> signatories = new ArrayList<Signatory>();

        //转让方
        Signatory signatory1 = new Signatory();
        //接收人联系方式：手机号、电子邮箱号（签署方为个人时联系方式（contact）或编号（receiverNumber）至少传递一个）
        signatory1.setContact(localContract.getVendorUserPhone());
        //	签署方类型：COMPANY（企业），PERSONAL（个人）
        signatory1.setTenantType(TenantType.COMPANY);
        //签署方名称
        signatory1.setTenantName(localContract.getVendorName());
        signatory1.setSerialNo(2); // 签署顺序，从1开始
        //接收人姓名
        signatory1.setReceiverName(localContract.getVendorUserName());

        //受让方
        Signatory signatory2 = new Signatory();
        //接收人联系方式：手机号、电子邮箱号（签署方为个人时联系方式（contact）或编号（receiverNumber）至少传递一个）
        signatory2.setContact(localContract.getMatCompanyUserPhone());
        //	签署方类型：COMPANY（企业），PERSONAL（个人）
        signatory2.setTenantType(TenantType.COMPANY);
        //签署方名称
        signatory2.setTenantName(localContract.getMatCompanyName());
        signatory2.setSerialNo(1); // 签署顺序，从1开始
        //接收人姓名
        signatory2.setReceiverName(localContract.getMatCompanyUserName());

        // 添加签署方
        signatories.add(signatory1);
        signatories.add(signatory2);
        createContractRequest.setSignatories(signatories);

        //用印流程id
        createContractRequest.setCategoryId(contrStreamId);

        //文档参数
        createContractRequest.setDocumentParams(params);

        Long contractId = null;
        try {
            //创建合同
            contractId = contractService.createContractByCategory(createContractRequest);
        } catch (PrivateAppException e) {
            e.printStackTrace();
        }

        System.out.println("创建合同成功,contractId:"+contractId);

        //本地合同表状态改为签订中【2】
//        localContract.setStatus(2);
        localContract.setThreeContractId(contractId.toString());
        super.updateById(localContract);

        //合同浏览页面方法调用
//        ViewUrlRequest request = new ViewUrlRequest();
//        request.setContractId(contractId);
//        request.setPageType(ViewUrlRequest.PageType.CONTENT);
//        String viewUrl = null;
//        try {
//            viewUrl = contractService.viewUrl(request);
//        } catch (PrivateAppException e) {
//            e.printStackTrace();
//        }
//
//        System.out.println("合同查看链接:"+viewUrl);
//        return viewUrl;
        return "";
    }

    @Override
    public void sendContract(String threeContrId) throws Exception {
        //初始化
        init();
        SendContractRequest request = new SendContractRequest();
        request.setContractId(Long.valueOf(threeContrId));
        contractService.send(request);
    }

}
