package com.artfess.cgpt.contract.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.model.ContractCallBack;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2023/3/15 17:57
 */
public interface ContractCallBackManager extends BaseManager<ContractCallBack> {
    PageList<ContractCallBack> queryAllByPage(QueryFilter<ContractCallBack> queryFilter);

    /**
     * 第三方合同签署完成后回调接口（保存记录并更新用户注册状态）
     * dataSourceType（1.合同，2.附件）
     */
    void signingCompleted(String contractId, String sn, String status,
                          String type, String contact,
                          String operatorName, String operatorMobile,
                          String operatorNumber,String receiverNumber,
                          String accessKey, String secretKey,
                          Integer dataSourceType);

}
