package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 开标记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizBidOpening对象", description="开标记录表")
@TableName("biz_bid_opening")
@Data
public class BizBidOpening extends BizModel<BizBidOpening> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATE_TIME_")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATE_USER_ID_")
    private String operateUserId;

    @ApiModelProperty(value = "操作人账号")
    @TableField("OPERATE_USER_ACCOUNT_")
    private String operateUserAccount;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATE_USER_NAME_")
    private String operateUserName;

    @ApiModelProperty(value = "操作类型（1.开标，2.流标，3.开启新一轮报价）")
    @TableField("OPERATE_TYPE_")
    private Integer operateType;

    @ApiModelProperty(value = "报价轮次")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;

    @ApiModelProperty(value = "操作方式（1.手动，2.系统自动）")
    @TableField("OPERATE_METHOD_")
    private Integer operateMethod;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "评标方法（1.最低价评标法，2.综合评标法）")
    @TableField("EVALUATION_METHOD_")
    private Integer evaluationMethod;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
