package com.artfess.cgpt.bidding.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 评标记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizBidEvaluation对象", description="评标记录表")
@TableName("biz_bid_evaluation")
@Data
public class BizBidEvaluation extends BizModel<BizBidEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATE_TIME_")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATE_USER_ID_")
    private String operateUserId;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATE_USER_NAME_")
    private String operateUserName;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    @Excel(name = "需求单位")
    private String procureOrgName;

    @ApiModelProperty(value = "报价记录ID（关联报价表ID）")
    @TableField("QUOTATION_ID_")
    private String quotationId;

    @ApiModelProperty(value = "报价公司ID")
    @TableField("QUOTATION_ORG_ID_")
    private String quotationOrgId;

    @ApiModelProperty(value = "报价公司编号")
    @TableField("QUOTATION_ORG_CODE_")
    private String quotationOrgCode;

    @ApiModelProperty(value = "评标方法（1：综合评标法，2：最低价评标法）")
    @TableField("EVALUATING_METHODS_")
    private Integer evaluatingMethods;

    @ApiModelProperty(value = "评标方式（1.以物料评标，2.以供应商评标）")
    @TableField("EVALUATION_MODE_")
    private Integer evaluationMode;

    @ApiModelProperty(value = "评标项ID")
    @TableField("EVALUATION_ID_")
    private String evaluationId;

    @ApiModelProperty(value = "评标项编码")
    @TableField("EVALUATION_CODE_")
    private String evaluationCode;

    @ApiModelProperty(value = "评标项名称")
    @TableField("EVALUATION_NAME_")
    private String evaluationName;

    @ApiModelProperty(value = "评标分值")
    @TableField("EVALUATION_SCORE_")
    private BigDecimal evaluationScore;

    @ApiModelProperty(value = "得分")
    @TableField("SCORE_")
    private BigDecimal score;

    @ApiModelProperty(value = "评标说明")
    @TableField("EVA_EXPLAIN_")
    private String evaExplain;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "得分排名")
    @TableField("RANK_")
    private Integer rank;

    @ApiModelProperty(value = "状态（1：已评标，2：定标审核中，3：已定标，4：已发布成交通知），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "供货份额分配率（%）")
    @TableField("SHARE_ALLOCATION_RATE_")
    private BigDecimal shareAllocationRate;

    @ApiModelProperty(value = "供货数量")
    @TableField("SHARE_ALLOCATION_NUM_")
    private BigDecimal shareAllocationNum;

    @ApiModelProperty(value = "评分详情明细集合")
    @TableField(exist = false)
    private List<BidEvaluationDetail> evaluationDetailList;

    @ApiModelProperty(value = "评分详情集合")
    @TableField(exist = false)
    private List<BidEvaluationRecord> evaluationRecordList;


    @ApiModelProperty(value = "物料ID")
    @TableField(exist = false)
    private String matId;

    @ApiModelProperty(value = "物料编码")
    @TableField(exist = false)
    @Excel(name = "企业物料编号")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField(exist = false)
    @Excel(name = "平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField(exist = false)
    @Excel(name = "物料名称")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField(exist = false)
    @Excel(name = "物料牌号")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField(exist = false)
    @Excel(name = "规格型号")
    private String matSpec;

    @ApiModelProperty(value = "数量")
    @TableField(exist = false)
    @Excel(name = "数量")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField(exist = false)
    @Excel(name = "计量单位")
    private String matUnit;

    @ApiModelProperty(value = "计划编号")
    @TableField(exist = false)
    @Excel(name = "计划编号")
    private String planCode;

    @ApiModelProperty(value = "最高限价(元)")
    @TableField(exist = false)
    @Excel(name = "最高限价(元)")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "基础扩展")
    @TableField(exist = false)
    @Excel(name = "基础扩展")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField(exist = false)
    @Excel(name = "其他扩展")
    private String matOtherExt;

    @ApiModelProperty(value = "需求日期")
    @TableField(exist = false)
    @Excel(name = "需求日期")
    private LocalDate demandDate;

    @ApiModelProperty(value = "送货地址")
    @TableField(exist = false)
    @Excel(name = "送货地址")
    private String unloadAddress;

    @ApiModelProperty(value = "企业补充说明")
    @TableField(exist = false)
    @Excel(name = "企业补充说明")
    private String matRemarks;

    @ApiModelProperty(value = "报价公司名称")
    @TableField("QUOTATION_ORG_NAME_")
    @Excel(name = "供应商")
    private String quotationOrgName;

    @ApiModelProperty(value = "报价单价")
    @TableField("QUOTATION_PRICE_")
    @Excel(name = "单价（元）")
    private BigDecimal quotationPrice;

    @ApiModelProperty(value = "报价总额（单价*数量）")
    @TableField("QUOTATION_AMOUNT_")
    @Excel(name = "总额（元）")
    private BigDecimal quotationAmount;

    @ApiModelProperty(value = "投标补充说明")
    @TableField(exist = false)
    @Excel(name = "投标补充说明")
    private String tenderExplain;

    @ApiModelProperty(value = "物料分类编号")
    @TableField(exist = false)
    private String matCategoryCode;
    @ApiModelProperty(value = "品牌")
    @TableField(exist = false)
    private String matBrand;
    @ApiModelProperty(value = "税率")
    @TableField(exist = false)
    private Integer taxRate;
    @ApiModelProperty(value = "物料状态（1：未评标，2：已评标，3：已定标，4：已中标，5：流标）")
    @TableField(exist = false)
    private Integer bidStatus;
    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField(exist = false)
    private Integer acceptanceTime;
    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField(exist = false)
    private Integer pendingTime;
    @ApiModelProperty(value = "是否含税（0.不含税，1.含税）")
    @TableField(exist = false)
    private Integer isTax;

    @ApiModelProperty(value = "采购申请明细ID")
    @TableField(exist = false)
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "采购申请ID")
    @TableField(exist = false)
    private String purchasingApplicationId;

    @ApiModelProperty(value = "报价模版明细数据集合")
    @TableField(exist = false)
    private List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;


    @ApiModelProperty(value = "明细来源类型（1.项目库引入，2.项目申请引入，3.手工添加，4.自动生成）")
    @TableField(exist = false)
    private Integer projectSourceType;
    @ApiModelProperty(value = "项目申请ID（关联项目申请表ID）")
    @TableField(exist = false)
    private String projectInfoId;
    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField(exist = false)
    private String projectLedgerId;
    @ApiModelProperty(value = "项目库编号（关联项目库编号）")
    @TableField(exist = false)
    private String projectLedgerCode;
    @ApiModelProperty(value = "明细类型（1.服务，2.工程，3.设备，4.物资），默认4")
    @TableField(exist = false)
    private Integer detailType;
    @ApiModelProperty(value = "服务开始时间")
    @TableField(exist = false)
    private LocalDate serviceStartTime;
    @ApiModelProperty(value = "服务结束时间")
    @TableField(exist = false)
    private LocalDate serviceEndTime;
    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField(exist = false)
    private BigDecimal buildingArea;
    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField(exist = false)
    private BigDecimal constructionEngineering;
    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField(exist = false)
    private BigDecimal equipmentProcurement;
    @ApiModelProperty(value = "其他费用(万元)")
    @TableField(exist = false)
    private BigDecimal otherExpenses;
    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField(exist = false)
    private Integer equipmentClassification;
    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField(exist = false)
    private String technicalRequirement;
    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField(exist = false)
    private Integer projectStatus;
    @ApiModelProperty(value = "项目描述")
    @TableField(exist = false)
    private String projectDescript;
    @ApiModelProperty(value = "责任人ID")
    @TableField(exist = false)
    private String personLiableId;
    @ApiModelProperty(value = "责任人姓名")
    @TableField(exist = false)
    private String personLiableName;
    @ApiModelProperty(value = "责任人联系方式")
    @TableField(exist = false)
    private String personLiablePhone;
    @ApiModelProperty(value = "保证金（元），默认0")
    @TableField(exist = false)
    private BigDecimal bond;

}
