package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:报价记录_报价模版明细关联数据表
 * @Author: Rong Tao
 * @Date: 2024/6/26 18:34
 */
@ApiModel(value="BiddingQuotationTemplateDetailData对象", description="报价记录_报价模版明细关联数据表")
@TableName("biz_bidding_quotation_template_detail_data")
@Data
public class BiddingQuotationTemplateDetailData extends BizNoModel<BiddingQuotationTemplateDetailData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "当前报价ID")
    @TableField("QUOTATION_ID_")
    private String quotationId;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "报价模版ID（关联报价模版表ID）")
    @TableField("TEMPLATE_ID_")
    private String templateId;

    @ApiModelProperty(value = "报价模版明细ID")
    @TableField("TEMPLATE_DETAIL_ID_")
    private String templateDetailId;

    @ApiModelProperty(value = "报价列名称")
    @TableField("QUO_ARRANGE_")
    private String quoArrange;

    @ApiModelProperty(value = "参数值")
    @TableField("VALUE_")
    private String value;

    @ApiModelProperty(value = "价格录入项（0：否，1：单价，2：总价）")
    @TableField("PRICE_ENTRY_")
    private Integer priceEntry;

}