package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description:评标明细记录表（综合评标法）
 * @Author: Rong Tao
 * @Date: 2024/6/30 11:11
 */
@ApiModel(value="BidEvaluationDetail对象", description="评标明细记录表（综合评标法）")
@Data
@TableName("biz_bid_evaluation_detail")
public class BidEvaluationDetail extends BizNoModel<BidEvaluationDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评标详情表ID")
    @TableField("BID_EVA_RECORD_ID_")
    private String bidEvaRecordId;

    @ApiModelProperty(value = "评分项父级ID（评分因素）")
    @TableField("EVALUATION_ITEM_PID_")
    private String evaluationItemPid;

    @ApiModelProperty(value = "立项评标模版历史ID（关联立项评标模版历史ID表ID）")
    @TableField("EVALUATION_SYSTEM_ID_")
    private String evaluationSystemId;

    @ApiModelProperty(value = "评标模版历史明细表ID")
    @TableField("EVALUATION_SYSTEM_DETAIL_ID_")
    private String evaluationSystemDetailId;

    @ApiModelProperty(value = "评分项父级名称（评分因素）")
    @TableField("EVALUATION_ITEM_PNAME_")
    private String evaluationItemPname;

    @ApiModelProperty(value = "评分内容")
    @TableField("EVALUATION_ITEM_CODE_")
    private String evaluationItemCode;

    @ApiModelProperty(value = "评分标准")
    @TableField("EVALUATION_STANDARD_")
    private String evaluationStandard;

    @ApiModelProperty(value = "分值")
    @TableField("EVALUATION_SCORE_")
    private BigDecimal evaluationScore;

    @ApiModelProperty(value = "得分")
    @TableField("SCORE_")
    private BigDecimal score;

    @ApiModelProperty(value = "评标说明")
    @TableField("EVA_EXPLAIN_")
    private String evaExplain;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
