package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.bidding.dao.QuotationTemplateDetailDao;
import com.artfess.cgpt.bidding.manager.QuotationTemplateDetailManager;
import com.artfess.cgpt.bidding.manager.QuotationTemplateManager;
import com.artfess.cgpt.bidding.model.QuotationTemplate;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:25
 */
@Service
public class QuotationTemplateDetailManagerImpl extends BaseManagerImpl<QuotationTemplateDetailDao, QuotationTemplateDetail> implements QuotationTemplateDetailManager {

    @Override
    public PageList<QuotationTemplateDetail> queryAllByPage(QueryFilter<QuotationTemplateDetail> queryFilter) {
        queryFilter.addFilter("IS_DELE_","1", QueryOP.NOT_EQUAL);
        IPage<QuotationTemplateDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<QuotationTemplateDetail> queryQuoValueByPage(QueryFilter<QuotationTemplateDetail> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","1", QueryOP.NOT_EQUAL);
        IPage<QuotationTemplateDetail> result = baseMapper.queryQuoValueByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
