package com.artfess.cgpt.bidding.manager.impl;

import cn.hutool.json.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.CalibrationDao;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/4/26 10:48
 */
@Service
public class CalibrationManagerImpl extends BaseManagerImpl<CalibrationDao, Calibration> implements CalibrationManager {

    @Autowired
    private CalibrationDetailManager caDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private MatApprovalDetailsManager maDetailManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager paDetailManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;

    @Override
    public PageList<Calibration> queryAllByPage(QueryFilter<Calibration> queryFilter) {
        IPage<Calibration> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveByCalibra(BizBiddingQuotation biddingQuotation) {
        LambdaQueryWrapper<Calibration> caQW = new LambdaQueryWrapper<>();
        caQW.eq(Calibration::getNoticeId, biddingQuotation.getNoticeId())
                .eq(Calibration::getNoticeType, biddingQuotation.getNoticeType())
                .eq(Calibration::getIsDele, "0");
        super.remove(caQW);
        LambdaQueryWrapper<CalibrationDetail> caDetailQW = new LambdaQueryWrapper<>();
        caDetailQW.eq(CalibrationDetail::getNoticeId, biddingQuotation.getNoticeId());
        caDetailManager.remove(caDetailQW);
        //立项类型
        String noticeType = biddingQuotation.getNoticeType();

        //保存定标记录
        Calibration calibration = new Calibration();
        calibration.setNoticeId(biddingQuotation.getNoticeId());
        calibration.setNoticeType(Integer.valueOf(noticeType));
        calibration.setVendorId(biddingQuotation.getQuotationCompanyId());
        calibration.setVendorCode(biddingQuotation.getQuotationCompanyCode());
        calibration.setVendorName(biddingQuotation.getQuotationCompanyName());
        calibration.setWinBidPrice(biddingQuotation.getTotalPrice());
        calibration.setScore(biddingQuotation.getTotalScore());
        calibration.setRank(biddingQuotation.getRank());

        List<CalibrationDetail> calibraDetailList = new ArrayList<>();
        //查询报价明细
        LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
        quoQW.eq(BizBiddingQuotation::getQuotationRounds, biddingQuotation.getQuotationRounds())
                .eq(BizBiddingQuotation::getNoticeId, biddingQuotation.getNoticeId())
                .eq(BizBiddingQuotation::getNoticeType, biddingQuotation.getNoticeType())
                .eq(BizBiddingQuotation::getQuotationCompanyId, biddingQuotation.getQuotationCompanyId());
        List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);
        if (BeanUtils.isEmpty(quoList) || quoList.size() <= 0) throw new BaseException("报价明细异常");

        String procureOrgId = "";
        String procureOrgCode = "";
        String procureOrgName = "";

        if (noticeType.equals("1")) {
            MatApproval notice = matApprovalManager.getById(biddingQuotation.getNoticeId());
            notice.setBidStatus(10);
            notice.setCalibraStatus(0);
            matApprovalManager.updateById(notice);
            calibration.setNoticeCode(notice.getProjectNumber());
            calibration.setNoticeName(notice.getNoticeTitle());
            procureOrgId = notice.getProcureOrgId();
            procureOrgCode = notice.getProcureOrgCode();
            procureOrgName = notice.getProcureOrgName();
        } else {
            ProjectApproval notice = projectApprovalManager.getById(biddingQuotation.getNoticeId());
            notice.setBidStatus(10);
            notice.setCalibraStatus(0);
            projectApprovalManager.updateById(notice);
            calibration.setNoticeCode(notice.getNoticeCode());
            calibration.setNoticeName(notice.getNoticeTitle());
            procureOrgId = notice.getProcureOrgId();
            procureOrgCode = notice.getProcureOrgCode();
            procureOrgName = notice.getProcureOrgName();
        }

        super.save(calibration);

        for (BizBiddingQuotation quo : quoList) {
            //保存定标明细记录
            CalibrationDetail caliDetail = new CalibrationDetail();
            caliDetail.setCalibrationId(calibration.getId());
            caliDetail.setNoticeId(quo.getNoticeId());
            caliDetail.setVendorId(quo.getQuotationCompanyId());
            caliDetail.setVendorCode(quo.getQuotationCompanyCode());
            caliDetail.setVendorName(quo.getQuotationCompanyName());
            caliDetail.setNoticeDetailedId(quo.getNoticeDetailedId());
            caliDetail.setIsTax(quo.getIsTax());
            caliDetail.setStatus(1);
            caliDetail.setWinBidPrice(quo.getQuotationPrice());
            caliDetail.setNoticeCode(calibration.getNoticeCode());
            caliDetail.setNoticeName(calibration.getNoticeName());
            caliDetail.setProcureOrgId(procureOrgId);
            caliDetail.setProcureOrgCode(procureOrgCode);
            caliDetail.setProcureOrgName(procureOrgName);

            if (noticeType.equals("1")) {
                MatApprovalDetails detail = maDetailManager.getById(quo.getNoticeDetailedId());
                caliDetail.setMatId(detail.getMatId());
                caliDetail.setMatPlatcode(detail.getMatPlatcode());
                caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
                caliDetail.setMatCode(detail.getMatCode());
                caliDetail.setMatName(detail.getMatName());
                caliDetail.setMatMaterial(detail.getMatMaterial());
                caliDetail.setMatSpec(detail.getMatSpec());
                caliDetail.setMatNum(detail.getMatNum());
                caliDetail.setMatUnit(detail.getMatUnit());
                caliDetail.setMatBrand(detail.getMatBrand());
                caliDetail.setMatBaseExt(detail.getMatBaseExt());
                caliDetail.setMatOtherExt(detail.getMatOtherExt());
                caliDetail.setTaxRate(detail.getTaxRate());
                calibraDetailList.add(caliDetail);
            } else {
                ProjectApprovalDetails detail = paDetailManager.getById(biddingQuotation.getNoticeDetailedId());
                caliDetail.setMatId(detail.getMatId());
                caliDetail.setMatPlatcode(detail.getMatPlatcode());
                caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
                caliDetail.setMatCode(detail.getMatCode());
                caliDetail.setMatName(detail.getMatName());
                caliDetail.setMatMaterial(detail.getMatMaterial());
                caliDetail.setMatSpec(detail.getMatSpec());
                caliDetail.setMatNum(detail.getMatNum());
                caliDetail.setMatUnit(detail.getMatUnit());
                caliDetail.setMatBrand(detail.getMatBrand());
                caliDetail.setMatBaseExt(detail.getMatBaseExt());
                caliDetail.setMatOtherExt(detail.getMatOtherExt());
                caliDetail.setTaxRate(detail.getTaxRate());
                calibraDetailList.add(caliDetail);
            }
        }

        caDetailManager.saveBatch(calibraDetailList);
    }

}
