package com.artfess.cgpt.bidding.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.artfess.base.constants.WebsocketConst;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.webSocket.PushService;
import com.artfess.cgpt.bidding.manager.*;
import com.artfess.cgpt.bidding.model.*;
import com.artfess.cgpt.bidding.dao.BizBiddingQuotationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.bidding.vo.QuoVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.ProjectEvaluationExpert;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 当前报价表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizBiddingQuotationManagerImpl extends BaseManagerImpl<BizBiddingQuotationDao, BizBiddingQuotation> implements BizBiddingQuotationManager {

    @Autowired
    PushService pushService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private BizBiddingQuotationHistoryManager quotationHistoryManager;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager quotationTemplateDetailDataManager;
    @Autowired
    private BidEvaluationRecordManager evaluationRecordManager;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;

    @Override
    public PageList<BizBiddingQuotation> queryAllByPage(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageQuoAndMatDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = baseMapper.pageMatDetail(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    //2024-07-05 09:31
//    @Override
//    public PageList<BizBiddingQuotation> pageMatDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
//        IPage<BizBiddingQuotation> result = baseMapper.pageMatDetail(convert2IPage(queryFilter.getPageBean()),
//                convert2Wrapper(queryFilter, currentModelClass()));
//
//        List<BizBiddingQuotation> records = result.getRecords();
//        if(BeanUtils.isNotEmpty(records) && records.size()>0){
//            for(BizBiddingQuotation s : records){
//                //查询评标信息
//                LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
//                bidEvaQW.eq(BizBidEvaluation::getQuotationId,s.getId())
//                        .eq(BizBidEvaluation::getIsDele,"0")
//                        .orderByDesc(BizBidEvaluation::getOperateTime)
//                        .last("limit 1");
//                BizBidEvaluation bidEvaluation = bidEvaluationManager.getBaseMapper().selectOne(bidEvaQW);
//                if(BeanUtils.isNotEmpty(bidEvaluation)){
//                    if(BeanUtils.isNotEmpty(bidEvaluation.getScore())){
//                        s.setTotalScore(new BigDecimal(String.valueOf(bidEvaluation.getScore())));
//                    }
//                    s.setIsEva(1);
//                    if(BeanUtils.isNotEmpty(bidEvaluation.getEvaExplain())){
//                        s.setEvaExplain(bidEvaluation.getEvaExplain());
//                        List<Accessory> evaExplainAccessory = accessoryService.getAccessoryBySourceId(bidEvaluation.getId());
//                        if(BeanUtils.isNotEmpty(evaExplainAccessory)){
//                            s.setEvaExplainAccessory(evaExplainAccessory);
//                        }
//                    }
//                }else {
//                    s.setIsEva(0);
//                }
//
//                //查询报价模版信息
//                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
//                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,s.getId());
//                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
//                s.setQuotationTemplateDetailDataList(templateDataList);
//            }
//
//        }
//
//        return new PageList<>(result);
//    }

    @Override
    public PageList<BizBiddingQuotation> pageMatDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        Integer noticeType = 1;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equals("noticeType") || qf.getProperty().equals("quo.NOTICE_TYPE_")){
                    noticeType = Integer.valueOf(qf.getValue().toString());
                }
            }
        }

        IPage<BizBiddingQuotation> result = null;

        if(noticeType==1){
            //物料
            result = baseMapper.pageMatDetail(convert2IPage(queryFilter.getPageBean()),
                    convert2Wrapper(queryFilter, currentModelClass()));
        }else {
            //项目
            result = baseMapper.pageProDetail(convert2IPage(queryFilter.getPageBean()),
                    convert2Wrapper(queryFilter, currentModelClass()));
        }

        List<BizBiddingQuotation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation s : records){
                //查询评标信息
                LambdaQueryWrapper<BidEvaluationRecord> bidEvaQW = new LambdaQueryWrapper<>();
                bidEvaQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                        .eq(BidEvaluationRecord::getNoticeId,s.getNoticeId())
                        .eq(BidEvaluationRecord::getNoticeDetailedId,s.getNoticeDetailedId())
                        .eq(BidEvaluationRecord::getQuotationOrgId,s.getQuotationCompanyId())
                        .orderByDesc(BidEvaluationRecord::getOperateTime)
                        .last("limit 1");
                BidEvaluationRecord evaRecord = evaluationRecordManager.getBaseMapper().selectOne(bidEvaQW);

                if(BeanUtils.isNotEmpty(evaRecord)){
                    if(BeanUtils.isNotEmpty(evaRecord.getScore())){
                        s.setTotalScore(evaRecord.getScore());
                    }
                    s.setIsEva(1);
                    if(BeanUtils.isNotEmpty(evaRecord.getEvaExplain())){
                        s.setEvaExplain(evaRecord.getEvaExplain());
                        List<Accessory> evaExplainAccessory = accessoryService.getAccessoryBySourceId(evaRecord.getId());
                        if(BeanUtils.isNotEmpty(evaExplainAccessory)){
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                }else {
                    s.setIsEva(0);
                }

                //查询报价模版信息
                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,s.getId());
                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);
            }

        }

        return new PageList<>(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageQuoOrg(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = baseMapper.queryGroupOrgByPage(new Page<>(0,-1,false),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<BizBiddingQuotation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation s : records){
                //查询最后一次报价金额
                LambdaQueryWrapper<BizBiddingQuotation> lastQuoQW = new LambdaQueryWrapper<>();
                lastQuoQW.eq(BizBiddingQuotation::getNoticeId,s.getNoticeId())
                        .eq(BeanUtils.isNotEmpty(s.getNoticeDetailedId()),BizBiddingQuotation::getNoticeDetailedId,s.getNoticeDetailedId())
                        .eq(BizBiddingQuotation::getQuotationCompanyId,s.getQuotationCompanyId())
                        .orderByDesc(BizBiddingQuotation::getQuotationTime)
                        .last("limit 1");
                BizBiddingQuotation lastQuo = baseMapper.selectOne(lastQuoQW);
                s.setQuotationPrice(lastQuo.getQuotationPrice());
                s.setQuotationAmount(lastQuo.getQuotationAmount());

                //查询评标信息
                LambdaQueryWrapper<BidEvaluationRecord> bidEvaQW = new LambdaQueryWrapper<>();
                bidEvaQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                        .eq(BidEvaluationRecord::getNoticeId,s.getNoticeId())
                        .eq(BidEvaluationRecord::getNoticeDetailedId,s.getNoticeDetailedId())
                        .eq(BidEvaluationRecord::getQuotationOrgId,s.getQuotationCompanyId())
                        .eq(BidEvaluationRecord::getStatus,2)
                        .orderByDesc(BidEvaluationRecord::getOperateTime)
                        .last("limit 1");
                BidEvaluationRecord evaRecord = evaluationRecordManager.getBaseMapper().selectOne(bidEvaQW);

                if(BeanUtils.isNotEmpty(evaRecord)){
                    if(BeanUtils.isNotEmpty(evaRecord.getScore())){
                        s.setTotalScore(evaRecord.getScore());
                    }
                    s.setIsEva(1);
                    if(BeanUtils.isNotEmpty(evaRecord.getEvaExplain())){
                        s.setEvaExplain(evaRecord.getEvaExplain());
                        List<Accessory> evaExplainAccessory = accessoryService.getAccessoryBySourceId(evaRecord.getId());
                        if(BeanUtils.isNotEmpty(evaExplainAccessory)){
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                }else {
                    s.setIsEva(0);
                }

                //查询报价模版信息
                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,s.getId());
                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);
            }

        }

        return new PageList<>(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageProDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = baseMapper.pageProDetail(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageLowestEva(QueryFilter<BizBiddingQuotation> queryFilter) {
//        queryFilter.addFilter("QUOTATION_PRICE_",BigDecimal.ZERO,QueryOP.GREAT);
        IPage<BizBiddingQuotation> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        BigDecimal minPrice = baseMapper.getMinPrice(convert2Wrapper(queryFilter, currentModelClass()));
        List<BizBiddingQuotation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation s : records){
                if(BeanUtils.isNotEmpty(minPrice) && s.getQuotationPrice().compareTo(minPrice)==0) {
                    s.setIsLowest(1);
                }else {
                    s.setIsLowest(0);
                }

                //查询评标信息
                LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
                bidEvaQW.eq(BizBidEvaluation::getQuotationId,s.getId())
                        .eq(BizBidEvaluation::getIsDele,"0")
                        .orderByDesc(BizBidEvaluation::getOperateTime)
                        .last("limit 1");
                BizBidEvaluation bidEvaluation = bidEvaluationManager.getBaseMapper().selectOne(bidEvaQW);
                if(BeanUtils.isNotEmpty(bidEvaluation)){
                    s.setIsEva(1);
                    if(BeanUtils.isNotEmpty(bidEvaluation.getEvaExplain())){
                        s.setEvaExplain(bidEvaluation.getEvaExplain());
                        List<Accessory> evaExplainAccessory = accessoryService.getAccessoryBySourceId(bidEvaluation.getId());
                        if(BeanUtils.isNotEmpty(evaExplainAccessory)){
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                }else {
                    s.setIsEva(0);
                }

                //查询报价模版信息
                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,s.getId());
                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);

                //如果报价轮次大于1，查询历史报价
//                if(s.getQuotationRounds()>1){
//                    LambdaQueryWrapper<BizBiddingQuotation> hisQuoQW = new LambdaQueryWrapper<>();
//                    hisQuoQW.select(BizBiddingQuotation::getQuotationRounds,BizBiddingQuotation::getQuotationPrice)
//                            .lt(BizBiddingQuotation::getQuotationRounds,s.getQuotationRounds())
//                            .eq(BizBiddingQuotation::getNoticeId,s.getNoticeId())
//                            .eq(BizBiddingQuotation::getNoticeDetailedId,s.getNoticeDetailedId())
//                            .eq(BizBiddingQuotation::getQuotationCompanyId,s.getQuotationCompanyId());
//                    List<BizBiddingQuotation> hisQuoList = super.list(hisQuoQW);
//
//                    for(int i = 1;i<s.getQuotationRounds();i++){
//                        int finalI = i;
//                        BigDecimal price = BigDecimal.ZERO;
//                        if(BeanUtils.isNotEmpty(hisQuoList) && hisQuoList.size()>0){
//                            List<BigDecimal> collect = hisQuoList.stream().filter(d -> d.getQuotationRounds().equals(finalI)).map(d -> d.getQuotationPrice()).collect(Collectors.toList());
//                            if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
//                                price = collect.get(0);
//                            }
//                        }
//                        if(finalI==1){
//                            s.setQuoPrice1(price);
//                        }else if(finalI==2){
//                            s.setQuoPrice2(price);
//                        }else if(finalI==3){
//                            s.setQuoPrice3(price);
//                        }else if(finalI==4){
//                            s.setQuoPrice4(price);
//                        }
//                    }
//
//                }

            }

        }

        return new PageList<>(result);
    }

    @Override
    public Map<String, Map<String, String>> getGroupMinPrice(String noticeId,String round,String type) {
        return baseMapper.getGroupMinPrice(noticeId,round,type);
    }

    @Override
    public List<BizBiddingQuotation> getRankList(String noticeId,String noticeDetailId,String round,String type) {
        return baseMapper.getRankList(noticeId,noticeDetailId,round,type);
    }

    //2024-03-29 09:44
//    @Override
//    public void quoMat(QuoVo quoVo){
//        IUser user = ContextUtil.getCurrentUser();
//        MatApprovalDetails detail = quoVo.getMatApprovalDetails();
//        //通过报价传入的明细id和当前用户id查询当前用户是否报价
//        LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
//                .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
//                .eq(BizBiddingQuotation::getNoticeType,"1")
//                .eq(BizBiddingQuotation::getQuotationRounds,1)
//                .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
//                .orderByDesc(BizBiddingQuotation::getCreateTime)
//                .last("limit 1");
//        BizBiddingQuotation entity = baseMapper.selectOne(queryWrapper);
//        //生成批次号
//        String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "jpbj_pch");
//        //如果当前公司有该明细的报价数据，就更新数据
//        if(BeanUtil.isNotEmpty(entity)){
//            entity.setQuotationBacthNum(bacthNum);
//            entity.setQuotationPrice(quoVo.getQuoPrice());
//            entity.setQuotationTime(LocalDateTime.now());
//            entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//            entity.setQuotationUserId(user.getUserId());
//            entity.setQuotationUserAccount(user.getAccount());
//            entity.setQuotationUserName(user.getFullname());
//            entity.setQuotationUserPhone(user.getMobile());
//            super.updateById(entity);
////            bqhManager.saveOne(entity);
//        }else {
//            IGroup org = ContextUtil.getCurrentGroup();
//            entity = new BizBiddingQuotation();
//            entity.setQuotationRounds(1);
//            entity.setQuotationBacthNum(bacthNum);
//            entity.setNoticeId(detail.getNoticeId());
//            entity.setNoticeType("1");
//            entity.setNoticeDetailedId(detail.getId());
//            entity.setQuotationUserId(user.getUserId());
//            entity.setQuotationUserAccount(user.getAccount());
//            entity.setQuotationUserName(user.getFullname());
//            entity.setQuotationUserPhone(user.getMobile());
//            entity.setQuotationCompanyId(org.getGroupId());
//
//            //竞拍编号
//            Integer userNum = null;
//
////            userNum = baseMapper.getMaxCodeByNotice(biddingQuotationVO.getHandleNoticeId());
//            userNum = LocalDateTime.now().getSecond();
//            entity.setQuotationUserNum(BeanUtil.isEmpty(userNum)?1:userNum+1);
//            //竞拍价格
////            entity.setQuotationMethod();
////            entity.setIsTax();
//            entity.setTaxRate(detail.getTaxRate());
//            entity.setQuotationPrice(quoVo.getQuoPrice());
//            entity.setQuotationTime(LocalDateTime.now());
//            entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//            super.save(entity);
////            bqhManager.saveOne(entity);
//        }
//
//        //更新立项表投标结束时间
//        LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
//        noticeUW.set(MatApproval::getBiddingEndTime,quoVo.getAuctionEndDate())
//                .eq(MatApproval::getIsDele,"0")
//                .eq(MatApproval::getId,detail.getNoticeId());
//        matApprovalManager.update(noticeUW);
//
//        // 发送websocket给前端，通知前端刷新数据
//        HashMap<String, Object> map = new HashMap<>();
//        map.put(WebsocketConst.MSG_QUO, quoVo);
//        JSON parse = JSONUtil.parse(map);
//        pushService.pushMsgToAll(parse.toString());
//
//    }

    //2024-06-26 18:05
//    @Override
//    @Transactional
//    public void quoMat(QuoVo quoVo){
//        MatApproval notice = quoVo.getMatApproval();
//        List<MatApprovalDetails> detailList = notice.getDetailsList();
//
//        IUser user = ContextUtil.getCurrentUser();
//        IGroup org = ContextUtil.getCurrentGroup();
//        //生成批次号
//        String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "jpbj_pch");
//
//        String quoPriceRedisKey;
//        List<BizBiddingQuotation> quoData = new ArrayList<>();
//        for(MatApprovalDetails detail : detailList){
//            quoPriceRedisKey = "quoprice:" + detail.getId();
////            Object priceObj = redisUtil.get(quoPriceRedisKey);
////            if(BeanUtils.isNotEmpty(priceObj)){
////                BigDecimal quoPrice = (BigDecimal)priceObj;
////                if(quoPrice.compareTo(detail.getMyPrice()) <= 0){
////                    throw new BaseException("【"+detail.getMatName()+"】报价金额不能高于当前报价金额,请刷新页面后重试");
////                }
////            }
//
//            //通过报价传入的明细id和当前用户id查询当前用户是否报价
//            LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
//            queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
//                    .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
//                    .eq(BizBiddingQuotation::getNoticeType,"1")
//                    .eq(BizBiddingQuotation::getQuotationRounds,1)
//                    .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
//                    .orderByDesc(BizBiddingQuotation::getCreateTime)
//                    .last("limit 1");
//            BizBiddingQuotation entity = baseMapper.selectOne(queryWrapper);
//            //如果当前公司有该明细的报价数据，就更新数据
//            if(BeanUtil.isNotEmpty(entity)){
//                entity.setQuotationBacthNum(bacthNum);
//                entity.setQuotationPrice(detail.getMyPrice());
//                entity.setQuotationTime(LocalDateTime.now());
//                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//                entity.setQuotationUserId(user.getUserId());
//                entity.setQuotationUserAccount(user.getAccount());
//                entity.setQuotationUserName(user.getFullname());
//                entity.setQuotationUserPhone(user.getMobile());
////                super.updateById(entity);
////                quotationHistoryManager.saveOne(entity);
//            }else {
//                entity = new BizBiddingQuotation();
//                entity.setQuotationRounds(1);
//                entity.setQuotationBacthNum(bacthNum);
//                entity.setNoticeId(detail.getNoticeId());
//                entity.setNoticeType("1");
//                entity.setNoticeDetailedId(detail.getId());
//                entity.setQuotationUserId(user.getUserId());
//                entity.setQuotationUserAccount(user.getAccount());
//                entity.setQuotationUserName(user.getFullname());
//                entity.setQuotationUserPhone(user.getMobile());
//                entity.setQuotationCompanyId(org.getGroupId());
//                entity.setQuotationCompanyCode(org.getGroupCode());
//                entity.setQuotationCompanyName(org.getName());
//
//                //报价编号
//                Integer userNum = null;
////            userNum = baseMapper.getMaxCodeByNotice(biddingQuotationVO.getHandleNoticeId());
//                LocalDateTime now = LocalDateTime.now();
//                userNum = now.getHour()+now.getMinute()+now.getSecond();
//                entity.setQuotationNum(userNum);
//
//                entity.setMatNum(detail.getMatNum());
//                entity.setQuotationMethod(notice.getQuotationMethod());
//                entity.setIsTax(notice.getIsTax());
//                entity.setTaxRate(detail.getTaxRate());
//                entity.setQuotationPrice(detail.getMyPrice());
//                entity.setQuotationTime(LocalDateTime.now());
//                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
////                super.save(entity);
////                quotationHistoryManager.saveOne(entity);
//            }
//            if(BeanUtils.isNotEmpty(detail.getTenderExplain())) {
//                entity.setTenderExplain(detail.getTenderExplain());
//            }
//            quoData.add(entity);
//            redisUtil.set(quoPriceRedisKey, detail.getMyPrice(), 60*60*24);
//        }
//
//        if(quoData.size()>0){
//            super.saveOrUpdateBatch(quoData);
//            quotationHistoryManager.saveByQuoList(quoData);
//        }
//
//        //更新立项表投标结束时间
//        LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
//        noticeUW.set(MatApproval::getBiddingEndTime,quoVo.getAuctionEndDate())
//                .eq(MatApproval::getId,notice.getId())
//                .eq(MatApproval::getIsDele,"0");
//        matApprovalManager.update(noticeUW);
//
//        // 发送websocket给前端，通知前端刷新数据
//        HashMap<String, Object> map = new HashMap<>();
//        map.put(WebsocketConst.MSG_QUO, quoVo.getMatApproval());
//        JSON parse = JSONUtil.parse(map);
//        pushService.pushMsgToAll(parse.toString());
//
//    }

    //2024-03-29 11:03
//    @Override
//    public void quoProject(QuoVo quoVo) {
//        IUser user = ContextUtil.getCurrentUser();
//        ProjectApprovalDetails detail = quoVo.getProjectApprovalDetails();
//        //通过报价传入的明细id和当前用户id查询当前用户是否报价
//        LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
//                .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
//                .eq(BizBiddingQuotation::getNoticeType,"2")
//                .eq(BizBiddingQuotation::getQuotationRounds,1)
//                .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
//                .orderByDesc(BizBiddingQuotation::getCreateTime)
//                .last("limit 1");
//        BizBiddingQuotation entity = baseMapper.selectOne(queryWrapper);
//        //生成批次号
//        String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "jpbj_pch");
//        //如果当前公司有该明细的报价数据，就更新数据
//        if(BeanUtil.isNotEmpty(entity)){
//            entity.setQuotationBacthNum(bacthNum);
//            entity.setQuotationPrice(quoVo.getQuoPrice());
//            entity.setQuotationTime(LocalDateTime.now());
//            entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//            entity.setQuotationUserId(user.getUserId());
//            entity.setQuotationUserAccount(user.getAccount());
//            entity.setQuotationUserName(user.getFullname());
//            entity.setQuotationUserPhone(user.getMobile());
//            super.updateById(entity);
////            bqhManager.saveOne(entity);
//        }else {
//            IGroup org = ContextUtil.getCurrentGroup();
//            entity = new BizBiddingQuotation();
//            entity.setQuotationRounds(1);
//            entity.setQuotationBacthNum(bacthNum);
//            entity.setNoticeId(detail.getNoticeId());
//            entity.setNoticeType("2");
//            entity.setNoticeDetailedId(detail.getId());
//            entity.setQuotationUserId(user.getUserId());
//            entity.setQuotationUserAccount(user.getAccount());
//            entity.setQuotationUserName(user.getFullname());
//            entity.setQuotationUserPhone(user.getMobile());
//            entity.setQuotationCompanyId(org.getGroupId());
//
//            //竞拍编号
//            Integer userNum = null;
//
////            userNum = baseMapper.getMaxCodeByNotice(biddingQuotationVO.getHandleNoticeId());
//            userNum = LocalDateTime.now().getSecond();
//            entity.setQuotationUserNum(BeanUtil.isEmpty(userNum)?1:userNum+1);
//            //竞拍价格
////            entity.setQuotationMethod();
////            entity.setIsTax();
//            entity.setTaxRate(detail.getTaxRate());
//            entity.setQuotationPrice(quoVo.getQuoPrice());
//            entity.setQuotationTime(LocalDateTime.now());
//            entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//            super.save(entity);
////            bqhManager.saveOne(entity);
//        }
//
//        //更新立项表投标结束时间
//        LambdaUpdateWrapper<ProjectApproval> noticeUW = new LambdaUpdateWrapper<>();
//        noticeUW.set(ProjectApproval::getBiddingEndTime,quoVo.getAuctionEndDate())
//                .eq(ProjectApproval::getIsDele,"0")
//                .eq(ProjectApproval::getId,detail.getNoticeId());
//        projectApprovalManager.update(noticeUW);
//
//        // 发送websocket给前端，通知前端刷新数据
//        HashMap<String, Object> map = new HashMap<>();
//        map.put(WebsocketConst.MSG_QUO, quoVo);
//        JSON parse = JSONUtil.parse(map);
//        pushService.pushMsgToAll(parse.toString());
//
//    }


    @Override
    @Transactional
    public void quoMat(QuoVo quoVo){
        MatApproval notice = quoVo.getMatApproval();
        List<MatApprovalDetails> detailList = notice.getDetailsList();

        for(MatApprovalDetails detail : detailList){
            if(BeanUtils.isEmpty(detail.getMyPrice())){
                detail.setMyPrice(BigDecimal.ZERO);
            }
            if(BeanUtils.isEmpty(detail.getMyAmount())){
                detail.setMyAmount(BigDecimal.ZERO);
            }
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if(BeanUtils.isNotEmpty(quotationTemplateDetailDataList) && quotationTemplateDetailDataList.size()>0){
                List<String> priceCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 1 && BeanUtils.isNotEmpty(s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                List<String> amountCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 2 && BeanUtils.isNotEmpty(s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(priceCollect) && priceCollect.size()>0){
                    detail.setMyPrice(new BigDecimal(priceCollect.get(0)));
                }
                if(BeanUtils.isNotEmpty(amountCollect) && amountCollect.size()>0){
                    detail.setMyAmount(new BigDecimal(amountCollect.get(0)));
                }
            }

            if(detail.getMyPrice().compareTo(BigDecimal.ZERO)>0 && detail.getMyAmount().compareTo(BigDecimal.ZERO)==0){
                detail.setMyAmount(detail.getMyPrice().multiply(detail.getMatNum()));
            }else if(detail.getMyPrice().compareTo(BigDecimal.ZERO)==0 && detail.getMyAmount().compareTo(BigDecimal.ZERO)>0){
                detail.setMyPrice(detail.getMyAmount().divide(detail.getMatNum(),4,BigDecimal.ROUND_HALF_UP));
            }

            if(BeanUtils.isNotEmpty(detail.getMaximumPriceLimit())
                    && detail.getMaximumPriceLimit().compareTo(BigDecimal.ZERO)!=0
                    && detail.getMyPrice().compareTo(detail.getMaximumPriceLimit()) >0){
                throw new BaseException("标的ID【"+detail.getId()+"】报价不能高于最高限价");
            }

            //查询上一次报价金额
//            LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
//            queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
//                    .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
//                    .eq(BizBiddingQuotation::getNoticeType,"1")
//                    .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
//                    .orderByDesc(BizBiddingQuotation::getQuotationTime)
//                    .last("limit 1");
//            BizBiddingQuotation hisQuo = baseMapper.selectOne(queryWrapper);
//            if(BeanUtils.isNotEmpty(hisQuo) && BeanUtils.isNotEmpty(hisQuo.getQuotationPrice())){
//                if(detail.getMyPrice().compareTo(hisQuo.getQuotationPrice())>0){
//                    throw new BaseException("平台物料编号【"+detail.getMatPlatcode()+"】报价不能高于上一次报价");
//                }
//            }

        }

        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        //生成批次号
        String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "jpbj_pch");

//        String quoPriceRedisKey;
        List<BizBiddingQuotation> quoData = new ArrayList<>();
        for(MatApprovalDetails detail : detailList){
//            quoPriceRedisKey = "quoprice:" + detail.getId();

            //通过报价传入的明细id和当前用户id查询当前用户是否报价
            LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
                    .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
                    .eq(BizBiddingQuotation::getNoticeType,"1")
                    .eq(BizBiddingQuotation::getQuotationRounds,notice.getQuotationRoundsNum())
                    .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
                    .orderByDesc(BizBiddingQuotation::getQuotationTime)
                    .last("limit 1");
            BizBiddingQuotation entity = baseMapper.selectOne(queryWrapper);

            //如果当前公司有该明细的报价数据，就更新数据
            if(BeanUtil.isNotEmpty(entity)){
                entity.setQuotationBacthNum(bacthNum);
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(LocalDateTime.now());
                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
//                super.updateById(entity);
//                quotationHistoryManager.saveOne(entity);
            }else {
                entity = new BizBiddingQuotation();
                entity.setQuotationRounds(notice.getQuotationRoundsNum());
                entity.setQuotationBacthNum(bacthNum);
                entity.setNoticeId(detail.getNoticeId());
                entity.setNoticeType("1");
                entity.setNoticeDetailedId(detail.getId());
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
                entity.setQuotationCompanyId(org.getGroupId());
                entity.setQuotationCompanyCode(org.getGroupCode());
                entity.setQuotationCompanyName(org.getName());

                //报价编号
                Integer userNum = null;
//            userNum = baseMapper.getMaxCodeByNotice(biddingQuotationVO.getHandleNoticeId());
                LocalDateTime now = LocalDateTime.now();
                userNum = now.getHour()+now.getMinute()+now.getSecond();
                entity.setQuotationNum(userNum);

                entity.setMatNum(detail.getMatNum());
                entity.setQuotationMethod(notice.getQuotationMethod());
                entity.setIsTax(notice.getIsTax());
                entity.setTaxRate(detail.getTaxRate());
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(LocalDateTime.now());
                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
//                super.save(entity);
//                quotationHistoryManager.saveOne(entity);
            }

            if(BeanUtils.isNotEmpty(detail.getTenderExplain())) {
                entity.setTenderExplain(detail.getTenderExplain());
            }else {
                entity.setTenderExplain(null);
            }

            quoData.add(entity);
            super.saveOrUpdate(entity);
            String quoId = entity.getId();

            //清除历史报价模版明细数据
            LambdaQueryWrapper<BiddingQuotationTemplateDetailData> quoTemplateHisQW = new LambdaQueryWrapper<>();
            quoTemplateHisQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,quoId);
            quotationTemplateDetailDataManager.remove(quoTemplateHisQW);

            //保存报价模版明细数据
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if(BeanUtils.isNotEmpty(quotationTemplateDetailDataList) && quotationTemplateDetailDataList.size()>0){
                quotationTemplateDetailDataList.stream().forEach(s->{
                    s.setQuotationId(quoId);
                });
                quotationTemplateDetailDataManager.saveBatch(quotationTemplateDetailDataList);
            }

//            redisUtil.set(quoPriceRedisKey, detail.getMyPrice(), 60*60*24);
        }

        if(quoData.size()>0){
            quotationHistoryManager.saveByQuoList(quoData);
        }

        if(notice.getProcureType()==3){
            //更新立项表投标结束时间
            if(BeanUtils.isNotEmpty(quoVo.getAuctionEndDate())){
                LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
                noticeUW.set(MatApproval::getBiddingEndTime,quoVo.getAuctionEndDate())
                        .eq(MatApproval::getId,notice.getId())
                        .eq(MatApproval::getIsDele,"0");
                matApprovalManager.update(noticeUW);
            }

            // 发送websocket给前端，通知前端刷新数据
            HashMap<String, Object> map = new HashMap<>();
            map.put(WebsocketConst.MSG_QUO, quoVo.getMatApproval());
            JSON parse = JSONUtil.parse(map);
            pushService.pushMsgToAll(parse.toString());
        }

    }

    @Override
    @Transactional
    public void quoProject(QuoVo quoVo) {
        ProjectApproval notice = quoVo.getProjectApproval();
        List<ProjectApprovalDetails> detailList = notice.getDetailsList();

        for(ProjectApprovalDetails detail : detailList){
            if(BeanUtils.isEmpty(detail.getMyPrice())){
                detail.setMyPrice(BigDecimal.ZERO);
            }
            if(BeanUtils.isEmpty(detail.getMyAmount())){
                detail.setMyAmount(BigDecimal.ZERO);
            }
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if(BeanUtils.isNotEmpty(quotationTemplateDetailDataList) && quotationTemplateDetailDataList.size()>0){
                List<String> priceCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 1 && BeanUtils.isNotEmpty(s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                List<String> amountCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 2 && BeanUtils.isNotEmpty(s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(priceCollect) && priceCollect.size()>0){
                    detail.setMyPrice(new BigDecimal(priceCollect.get(0)));
                }
                if(BeanUtils.isNotEmpty(amountCollect) && amountCollect.size()>0){
                    detail.setMyAmount(new BigDecimal(amountCollect.get(0)));
                }
            }

            if(detail.getMyPrice().compareTo(BigDecimal.ZERO)>0 && detail.getMyAmount().compareTo(BigDecimal.ZERO)==0){
                detail.setMyAmount(detail.getMyPrice().multiply(detail.getMatNum()));
            }else if(detail.getMyPrice().compareTo(BigDecimal.ZERO)==0 && detail.getMyAmount().compareTo(BigDecimal.ZERO)>0){
                detail.setMyPrice(detail.getMyAmount().divide(detail.getMatNum(),4,BigDecimal.ROUND_HALF_UP));
            }

            if(BeanUtils.isNotEmpty(detail.getMaximumPriceLimit())
                    && detail.getMaximumPriceLimit().compareTo(BigDecimal.ZERO)!=0
                    && detail.getMyPrice().compareTo(detail.getMaximumPriceLimit()) >0){
                throw new BaseException("标的ID【"+detail.getId()+"】报价不能高于最高限价");
            }

        }

        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();

        //生成批次号
        String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "jpbj_pch");

        LocalDateTime nowTime = LocalDateTime.now();

        List<BizBiddingQuotation> quoData = new ArrayList<>();
        for(ProjectApprovalDetails detail : detailList){

            //通过报价传入的明细id和当前用户id查询当前用户是否报价
            LambdaQueryWrapper<BizBiddingQuotation> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BizBiddingQuotation::getNoticeId,detail.getNoticeId())
                    .eq(BizBiddingQuotation::getNoticeDetailedId,detail.getId())
                    .eq(BizBiddingQuotation::getNoticeType,"2")
                    .eq(BizBiddingQuotation::getQuotationRounds,notice.getQuotationRoundsNum())
                    .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
                    .orderByDesc(BizBiddingQuotation::getQuotationTime)
                    .last("limit 1");
            BizBiddingQuotation entity = baseMapper.selectOne(queryWrapper);

            //如果当前公司有该明细的报价数据，就更新数据
            if(BeanUtil.isNotEmpty(entity)){
                entity.setQuotationBacthNum(bacthNum);
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(nowTime);
                entity.setQuotationTimer(nowTime.toEpochSecond(ZoneOffset.of("+8")));
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
            }else {
                entity = new BizBiddingQuotation();
                entity.setQuotationRounds(notice.getQuotationRoundsNum());
                entity.setQuotationBacthNum(bacthNum);
                entity.setNoticeId(detail.getNoticeId());
                entity.setNoticeType("2");
                entity.setNoticeDetailedId(detail.getId());
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
                entity.setQuotationCompanyId(org.getGroupId());
                entity.setQuotationCompanyCode(org.getGroupCode());
                entity.setQuotationCompanyName(org.getName());

                //报价编号
                Integer userNum = null;
//            userNum = baseMapper.getMaxCodeByNotice(biddingQuotationVO.getHandleNoticeId());
                userNum = nowTime.getHour()+nowTime.getMinute()+nowTime.getSecond();
                entity.setQuotationNum(userNum);

                entity.setMatNum(detail.getMatNum());
                entity.setQuotationMethod(notice.getQuotationMethod());
                entity.setIsTax(notice.getIsTax());
                entity.setTaxRate(detail.getTaxRate());
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(nowTime);
                entity.setQuotationTimer(nowTime.toEpochSecond(ZoneOffset.of("+8")));
//                super.save(entity);
//            bqhManager.saveOne(entity);
            }

            if(BeanUtils.isNotEmpty(detail.getTenderExplain())) {
                entity.setTenderExplain(detail.getTenderExplain());
            }else {
                entity.setTenderExplain(null);
            }

            quoData.add(entity);
            super.saveOrUpdate(entity);
            String quoId = entity.getId();

            //清除历史报价模版明细数据
            LambdaQueryWrapper<BiddingQuotationTemplateDetailData> quoTemplateHisQW = new LambdaQueryWrapper<>();
            quoTemplateHisQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,quoId);
            quotationTemplateDetailDataManager.remove(quoTemplateHisQW);

            //保存报价模版明细数据
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if(BeanUtils.isNotEmpty(quotationTemplateDetailDataList) && quotationTemplateDetailDataList.size()>0){
                quotationTemplateDetailDataList.stream().forEach(s->{
                    s.setQuotationId(quoId);
                });
                quotationTemplateDetailDataManager.saveBatch(quotationTemplateDetailDataList);
            }

        }

        if(quoData.size()>0) {
            quotationHistoryManager.saveByQuoList(quoData);
        }

        if(notice.getProcureType()==3){
            //更新立项表投标结束时间
            if(BeanUtils.isNotEmpty(quoVo.getAuctionEndDate())){
                LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
                noticeUW.set(MatApproval::getBiddingEndTime,quoVo.getAuctionEndDate())
                        .eq(MatApproval::getId,notice.getId())
                        .eq(MatApproval::getIsDele,"0");
                matApprovalManager.update(noticeUW);
            }

            // 发送websocket给前端，通知前端刷新数据
            HashMap<String, Object> map = new HashMap<>();
            map.put(WebsocketConst.MSG_QUO, quoVo.getMatApproval());
            JSON parse = JSONUtil.parse(map);
            pushService.pushMsgToAll(parse.toString());
        }

    }

    @Override
    public MatApproval matBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter) {
        String noticeId = null;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        MatApproval notice = matApprovalManager.getById(noticeId);

        //查询评标专家
        LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
        evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,noticeId)
                .eq(ProjectEvaluationExpert::getProjectApprovalType,1)
                .eq(ProjectEvaluationExpert::getIsDele,"0");
        List<ProjectEvaluationExpert> evaluationExpertList = evaluationExpertManager.list(evaluationExpertQW);
        if(BeanUtils.isNotEmpty(evaluationExpertList)) {
            notice.setProjectEvaluationExpertList(evaluationExpertList);
        }

        queryFilter.addFilter("NOTICE_TYPE_","1", QueryOP.EQUAL);
        List<BizBiddingQuotation> records = baseMapper.groupOrgQuery(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation quo : records){
                QueryWrapper<BizBiddingQuotation> quoRoundsQW = new QueryWrapper<>();
                quoRoundsQW.select("QUOTATION_ROUNDS_ as 'quotationRounds',ROUND(SUM(QUOTATION_PRICE_*MAT_NUM_),2) as 'totalPrice'")
                        .lambda().eq(BizBiddingQuotation::getNoticeId,quo.getNoticeId())
                        .eq(BizBiddingQuotation::getQuotationCompanyId,quo.getQuotationCompanyId())
                        .groupBy(BizBiddingQuotation::getQuotationRounds);
                List<Map<String, Object>> mapList = baseMapper.selectMaps(quoRoundsQW);
                quo.setQuoPriceMap(mapList);
            }
        }

        notice.setQuotationList(records);
        return notice;
    }

    @Override
    public ProjectApproval proBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter) {
        String noticeId = null;
        String round = "1";
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        ProjectApproval notice = projectApprovalManager.getById(noticeId);

        //查询评标专家
        LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
        evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,noticeId)
                .eq(ProjectEvaluationExpert::getProjectApprovalType,2)
                .eq(ProjectEvaluationExpert::getIsDele,"0");
        List<ProjectEvaluationExpert> evaluationExpertList = evaluationExpertManager.list(evaluationExpertQW);
        if(BeanUtils.isNotEmpty(evaluationExpertList)) notice.setProjectEvaluationExpertList(evaluationExpertList);

        queryFilter.addFilter("NOTICE_TYPE_","2", QueryOP.EQUAL);
        List<BizBiddingQuotation> records = baseMapper.groupOrgQuery(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation quo : records){
                QueryWrapper<BizBiddingQuotation> quoRoundsQW = new QueryWrapper<>();
                quoRoundsQW.select("QUOTATION_ROUNDS_ as 'quotationRounds',SUM(QUOTATION_PRICE_*MAT_NUM_) as 'totalPrice'")
                        .lambda().eq(BizBiddingQuotation::getNoticeId,quo.getNoticeId())
                        .eq(BizBiddingQuotation::getQuotationCompanyId,quo.getQuotationCompanyId())
                        .groupBy(BizBiddingQuotation::getQuotationRounds);
                List<Map<String, Object>> mapList = baseMapper.selectMaps(quoRoundsQW);
                quo.setQuoPriceMap(mapList);
            }
        }

        notice.setQuotationList(records);
        return notice;
    }

    @Override
    public PageList<BizBiddingQuotation> evaOrgQuoData(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = baseMapper.groupOrgQuery(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        List<BizBiddingQuotation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBiddingQuotation quo : records){
//                LambdaQueryWrapper<BizBidEvaluation> evaQW = new LambdaQueryWrapper<>();
//                evaQW.eq(BizBidEvaluation::getQuotationOrgId,quo.getQuotationCompanyId())
//                        .eq(BizBidEvaluation::getNoticeId,quo.getNoticeId())
//                        .eq(BizBidEvaluation::getIsDele,"0")
//                        .orderByDesc(BizBidEvaluation::getOperateTime)
//                        .last("limit 1");

                //查询评标明细表该评标专家所评得分
                LambdaQueryWrapper<BidEvaluationRecord> evaRecordQW = new LambdaQueryWrapper<>();
                evaRecordQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                        .eq(BidEvaluationRecord::getNoticeId,quo.getNoticeId())
                        .eq(BidEvaluationRecord::getQuotationOrgId,quo.getQuotationCompanyId())
                        .orderByDesc(BidEvaluationRecord::getOperateTime)
                        .last("limit 1");
                BidEvaluationRecord evaRecord = evaluationRecordManager.getBaseMapper().selectOne(evaRecordQW);

//                BigDecimal totalScore = bidEvaluationManager.getTotalScore(quo.getQuotationCompanyId(), quo.getNoticeId());

                quo.setIsEva(0);
                if(BeanUtils.isNotEmpty(evaRecord)) {
                    quo.setTotalScore(evaRecord.getScore());
                    if(evaRecord.getStatus()==2){
                        quo.setIsEva(1);
                    }
                }

            }
        }

        return new PageList<>(result);
    }

    @Override
    public List<BizBiddingQuotation> evaOrgRankData(String noticeId) {
        List<BizBiddingQuotation> result = baseMapper.quoRankByNoticeId(noticeId);
        return result;
    }

    @Override
    public void exportDataToExcel(QueryFilter<BizBiddingQuotation> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "报价详情-导出结果";

        List<BizBiddingQuotation> data = pageQuoAndMatDetail(queryFilter).getRows();

        if(BeanUtils.isEmpty(data) || data.size()==0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        //付款方式字典
        List<DictModel> payMethodDic = sysDictionaryManager.queryDictListItemsByCode("cglx-fkfs");
        //是否含税方式字典
        List<DictModel> isTaxDic = sysDictionaryManager.queryDictListItemsByCode("cglx-sfhsj");

        for(BizBiddingQuotation temp : data){
            //翻译字典
            String payMethodStr = BizUtils.getDicValueByCode(payMethodDic,temp.getQuotationMethod());
            temp.setQuotationMethodStr(payMethodStr);

            String isTaxStr = BizUtils.getDicValueByCode(isTaxDic,temp.getIsTax());
            temp.setIsTaxStr(isTaxStr);
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,BizBiddingQuotation.class,data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

}
