package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.BidEvaluationRecordDao;
import com.artfess.cgpt.bidding.manager.BidEvaluationDetailManager;
import com.artfess.cgpt.bidding.manager.BidEvaluationRecordManager;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/4 19:59
 */
@Service
public class BidEvaluationRecordManagerImpl extends BaseManagerImpl<BidEvaluationRecordDao, BidEvaluationRecord> implements BidEvaluationRecordManager {

    @Autowired
    private BidEvaluationDetailManager evaluationDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizBiddingQuotationManager biddingQuotationManager;
    @Autowired
    private ProjectApprovalManager proApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager proApprovalDetailsManager;

    @Override
    public PageList<BidEvaluationRecord> queryAllByPage(QueryFilter<BidEvaluationRecord> queryFilter) {
        IPage<BidEvaluationRecord> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BidEvaluationRecord> pageAndDetail(QueryFilter<BidEvaluationRecord> queryFilter) {
        IPage<BidEvaluationRecord> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<BidEvaluationRecord> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BidEvaluationRecord temp : records){
                LambdaQueryWrapper<BidEvaluationDetail> detailQW = new LambdaQueryWrapper<>();
                detailQW.eq(BidEvaluationDetail::getBidEvaRecordId,temp.getId());
                temp.setEvaluationDetailList(evaluationDetailManager.list(detailQW));
            }
        }

        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveByEva(BidEvaluationRecord entity) {
        //清除当前专家对该供应商历史评标数据
        LambdaQueryWrapper<BidEvaluationRecord> hisQW = new LambdaQueryWrapper<>();
        hisQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                .eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType())
                .eq(BidEvaluationRecord::getQuotationOrgId,entity.getQuotationOrgId())
                .last("limit 1");
        BidEvaluationRecord evaHis = baseMapper.selectOne(hisQW);


        if(BeanUtils.isNotEmpty(evaHis)){
            //清除历史评标明细
            LambdaQueryWrapper<BidEvaluationDetail> evaDetailHisQW = new LambdaQueryWrapper<>();
            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaRecordId,evaHis.getId());
            evaluationDetailManager.remove(evaDetailHisQW);
            super.remove(evaHis.getId());
        }

        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();

        MatApproval notice = matApprovalManager.getById(entity.getNoticeId());

        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());

        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());

        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(2);
        entity.setStatus(1);
        super.save(entity);

        evaDetailList.forEach(s->s.setBidEvaRecordId(entity.getId()));
        evaluationDetailManager.saveBatch(evaDetailList);

//        if(entity.getNoticeType()==1){
//            LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
//            noticeUW.set(MatApproval::getBidStatus,6)
//                    .eq(MatApproval::getId,entity.getNoticeId())
//                    .eq(MatApproval::getIsDele,"0");
//            matApprovalManager.update(noticeUW);
//        }else {
//            LambdaUpdateWrapper<ProjectApproval> noticeUW = new LambdaUpdateWrapper<>();
//            noticeUW.set(ProjectApproval::getBidStatus,6)
//                    .eq(ProjectApproval::getId,entity.getNoticeId())
//                    .eq(ProjectApproval::getIsDele,"0");
//            projectApprovalManager.update(noticeUW);
//        }

    }

    @Override
    @Transactional
    public void submitBidEvaluationOrg(BidEvaluationRecord entity) {
        //查询当前专家对该立项的评标数据
        LambdaQueryWrapper<BidEvaluationRecord> dataQW = new LambdaQueryWrapper<>();
        dataQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                .eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType());
        List<BidEvaluationRecord> data = super.list(dataQW);
        if(BeanUtils.isEmpty(data) || data.size()<=0){
            throw new BaseException("暂无评标记录可提交");
        }

        //查询立项明细所有的报价单位
        QueryFilter<BizBiddingQuotation> quoOrgQF = QueryFilter.build();
        quoOrgQF.addFilter("NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
        List<BizBiddingQuotation> quoOrgList = biddingQuotationManager.evaOrgQuoData(quoOrgQF).getRows();

        if(quoOrgList.size()!=data.size()){
            throw new BaseException("请对所有投标单位进行评分保存后再进行提交");
        }

        //修改评标详情状态为已提交
        data.stream().forEach(s->s.setStatus(2));
        super.updateBatchById(data);

        MatApproval notice = matApprovalManager.getById(entity.getNoticeId());

        //查询该公告所有评标记录
        LambdaQueryWrapper<BidEvaluationRecord> evaDataQW = new LambdaQueryWrapper<>();
        evaDataQW.eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType())
                .eq(BidEvaluationRecord::getStatus,2);
        List<BidEvaluationRecord> evaluationRecordList = super.list(evaDataQW);

        //查询所有专家是否全部评完标
        List<String> operateUserIds = evaluationRecordList.stream().map(s -> s.getOperateUserId()).distinct().collect(Collectors.toList());
        if(operateUserIds.size()==notice.getEvaluationExpertNumber()){
            //删除历史评标总分记录
            LambdaQueryWrapper<BizBidEvaluation> bidEvaHisQW = new LambdaQueryWrapper<>();
            bidEvaHisQW.eq(BizBidEvaluation::getNoticeId,entity.getNoticeId())
                    .eq(BizBidEvaluation::getNoticeType,entity.getNoticeType())
                    .eq(BizBidEvaluation::getIsDele,"0");
            bidEvaluationManager.remove(bidEvaHisQW);

            Map<String, List<BidEvaluationRecord>> quoOrgGroupMap = evaluationRecordList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getQuotationOrgId));

            List<BizBidEvaluation> bidEvaSaveData = new ArrayList<>();
            quoOrgGroupMap.forEach((quoOrgId,evaData)->{
                //生成评标总分记录
                BizBidEvaluation evaluation = new BizBidEvaluation();
                evaluation.setOperateTime(LocalDateTime.now());
                evaluation.setNoticeId(entity.getNoticeId());
                evaluation.setNoticeCode(notice.getProjectNumber());
                evaluation.setNoticeName(notice.getNoticeTitle());
                evaluation.setNoticeType(entity.getNoticeType());
                evaluation.setProcureOrgId(notice.getProcureOrgId());
                evaluation.setProcureOrgCode(notice.getProcureOrgCode());
                evaluation.setProcureOrgName(notice.getProcureOrgName());
                evaluation.setQuotationOrgId(quoOrgId);
                evaluation.setQuotationOrgCode(evaData.get(0).getQuotationOrgCode());
                evaluation.setQuotationOrgName(evaData.get(0).getQuotationOrgName());
                evaluation.setQuotationPrice(evaData.get(0).getQuotationPrice());
                evaluation.setQuotationAmount(evaData.get(0).getQuotationAmount());
                evaluation.setEvaluatingMethods(1);
                evaluation.setEvaluationMode(2);

                //计算总分，所有得分/专家数量
                BigDecimal totalScore = BigDecimal.ZERO;
                for(BidEvaluationRecord temp: evaData){
                    totalScore = totalScore.add(temp.getScore());
                }
                evaluation.setScore(totalScore.divide(new BigDecimal(String.valueOf(evaData.size())), 2));
                evaluation.setStatus(1);
                bidEvaSaveData.add(evaluation);
            });

            bidEvaluationManager.saveBatch(bidEvaSaveData);

            if(entity.getNoticeType()==1){
                //更新明细状态为已评标
                LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                noticeDetailUW.set(MatApprovalDetails::getBidStatus,2)
                        .eq(MatApprovalDetails::getNoticeId,notice.getId())
                        .eq(MatApprovalDetails::getIsDele,"0");
                matApprovalDetailManager.update(noticeDetailUW);
                //更新立项状态为已评标
                notice.setBidStatus(6);
                matApprovalManager.updateById(notice);
            }
        }
    }

    @Override
    @Transactional
    public void saveByEvaMat(BidEvaluationRecord entity) {
        //清除当前专家对该供应商历史评标数据
        LambdaQueryWrapper<BidEvaluationRecord> hisQW = new LambdaQueryWrapper<>();
        hisQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                .eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType())
                .eq(BidEvaluationRecord::getNoticeDetailedId,entity.getNoticeDetailedId())
                .eq(BidEvaluationRecord::getQuotationOrgId,entity.getQuotationOrgId())
                .last("limit 1");
        BidEvaluationRecord evaHis = baseMapper.selectOne(hisQW);
        if(BeanUtils.isNotEmpty(evaHis)){
            //清除历史评标明细
            LambdaQueryWrapper<BidEvaluationDetail> evaDetailHisQW = new LambdaQueryWrapper<>();
            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaRecordId,evaHis.getId());
            evaluationDetailManager.remove(evaDetailHisQW);
            super.remove(evaHis.getId());
        }

        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();

        if(entity.getNoticeType()==1){
            //物资
            MatApproval notice = matApprovalManager.getById(entity.getNoticeId());
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
        }else {
            //项目
            ProjectApproval notice = proApprovalManager.getById(entity.getNoticeId());
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
        }

        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());

        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(1);
        entity.setStatus(1);
        super.save(entity);

        evaDetailList.forEach(s->s.setBidEvaRecordId(entity.getId()));
        evaluationDetailManager.saveBatch(evaDetailList);
    }

    @Override
    @Transactional
    public void submitBidEvaluation(BidEvaluationRecord entity) {
        //查询当前专家对该供应商的评标数据
        LambdaQueryWrapper<BidEvaluationRecord> dataQW = new LambdaQueryWrapper<>();
        dataQW.eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                .eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType())
                .eq(BidEvaluationRecord::getNoticeDetailedId,entity.getNoticeDetailedId());
        List<BidEvaluationRecord> data = super.list(dataQW);
        if(BeanUtils.isEmpty(data) || data.size()<=0){
            throw new BaseException("暂无评标记录可提交");
        }

        //查询立项明细所有的报价单位
        QueryFilter<BizBiddingQuotation> quoOrgQF = QueryFilter.build();
        quoOrgQF.addFilter("NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
        quoOrgQF.addFilter("NOTICE_DETAILED_ID_",entity.getNoticeDetailedId(),QueryOP.EQUAL);
        List<BizBiddingQuotation> quoOrgList = biddingQuotationManager.pageQuoOrg(quoOrgQF).getRows();

        if(quoOrgList.size()!=data.size()){
            throw new BaseException("请对该物料所有投标单位进行评分保存后再进行提交");
        }

        //修改评标详情状态为已提交
        data.stream().forEach(s->s.setStatus(2));
        super.updateBatchById(data);

        Integer evaExpertNumber = null;
        MatApproval matNotice = matApprovalManager.getById(entity.getNoticeId());
        ProjectApproval proNotice = proApprovalManager.getById(entity.getNoticeId());
        if(entity.getNoticeType()==1){
            //物资
            evaExpertNumber = matNotice.getEvaluationExpertNumber();
        }else {
            //项目
            evaExpertNumber = proNotice.getEvaluationExpertNumber();
        }

        //查询所有专家是否全部评完标
        LambdaQueryWrapper<BidEvaluationRecord> evaCountQW = new LambdaQueryWrapper<>();
        evaCountQW.eq(BidEvaluationRecord::getNoticeId,entity.getNoticeId())
                .eq(BidEvaluationRecord::getNoticeType,entity.getNoticeType())
                .eq(BidEvaluationRecord::getNoticeDetailedId,entity.getNoticeDetailedId())
                .eq(BidEvaluationRecord::getStatus,2);
        List<BidEvaluationRecord> evaluationRecordList = super.list(evaCountQW);

        List<String> evaUserList = evaluationRecordList.stream().map(s -> s.getOperateUserId()).distinct().collect(Collectors.toList());
        if(evaUserList.size() == evaExpertNumber){
            //删除历史评标总分记录
            LambdaQueryWrapper<BizBidEvaluation> bidEvaHisQW = new LambdaQueryWrapper<>();
            bidEvaHisQW.eq(BizBidEvaluation::getNoticeId,entity.getNoticeId())
                    .eq(BizBidEvaluation::getNoticeDetailedId,entity.getNoticeDetailedId())
                    .eq(BizBidEvaluation::getIsDele,"0");
            bidEvaluationManager.remove(bidEvaHisQW);

            Map<String, List<BidEvaluationRecord>> collect = evaluationRecordList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getNoticeDetailedId));
            collect.forEach((noticeDetailId,evaList)->{
                Map<String, List<BidEvaluationRecord>> tempList = evaList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getQuotationOrgId));
                tempList.forEach((quoOrgId,evaData)->{
                    BidEvaluationRecord evaTemp = evaData.get(0);
                    //生成评标总分记录
                    BizBidEvaluation evaluation = new BizBidEvaluation();
                    evaluation.setOperateTime(LocalDateTime.now());
                    evaluation.setNoticeType(evaTemp.getNoticeType());
                    evaluation.setNoticeId(evaTemp.getNoticeId());
                    evaluation.setNoticeCode(evaTemp.getNoticeCode());
                    evaluation.setNoticeName(evaTemp.getNoticeName());
                    evaluation.setNoticeDetailedId(evaTemp.getNoticeDetailedId());
                    evaluation.setProcureOrgId(evaTemp.getProcureOrgId());
                    evaluation.setProcureOrgCode(evaTemp.getProcureOrgCode());
                    evaluation.setProcureOrgName(evaTemp.getProcureOrgName());
                    evaluation.setQuotationOrgId(evaTemp.getQuotationOrgId());
                    evaluation.setQuotationOrgCode(evaTemp.getQuotationOrgCode());
                    evaluation.setQuotationOrgName(evaTemp.getQuotationOrgName());
                    evaluation.setQuotationPrice(evaTemp.getQuotationPrice());
                    evaluation.setQuotationAmount(evaTemp.getQuotationAmount());
                    evaluation.setEvaluatingMethods(1);
                    evaluation.setEvaluationMode(1);

                    //计算总分，所有得分/专家数量
                    BigDecimal totalScore = BigDecimal.ZERO;
                    for(BidEvaluationRecord temp: evaData){
                        totalScore = totalScore.add(temp.getScore());
                    }
                    evaluation.setScore(totalScore.divide(new BigDecimal(String.valueOf(evaData.size())), 2));
                    evaluation.setStatus(1);
                    bidEvaluationManager.save(evaluation);

                });

            });

            if(entity.getNoticeType()==1){
                //物资
                //更新明细状态为已评标
                LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                noticeDetailUW.set(MatApprovalDetails::getBidStatus,2)
                        .eq(MatApprovalDetails::getId,entity.getNoticeDetailedId())
                        .eq(MatApprovalDetails::getIsDele,"0");
                matApprovalDetailManager.update(noticeDetailUW);

                //查询该项目是否有未评标的明细
                LambdaQueryWrapper<MatApprovalDetails> approvalDetailQW = new LambdaQueryWrapper<>();
                approvalDetailQW.eq(MatApprovalDetails::getBidStatus,1)
                        .eq(MatApprovalDetails::getNoticeId,entity.getNoticeId())
                        .eq(MatApprovalDetails::getIsDele,"0");
                //如果没有，更新项目状态为已评标
                if(matApprovalDetailManager.count(approvalDetailQW)==0){
                    matNotice.setBidStatus(6);
                    matApprovalManager.updateById(matNotice);
                }
            }else {
                //项目
                //更新明细状态为已评标
                LambdaUpdateWrapper<ProjectApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                noticeDetailUW.set(ProjectApprovalDetails::getBidStatus,2)
                        .eq(ProjectApprovalDetails::getId,entity.getNoticeDetailedId())
                        .eq(ProjectApprovalDetails::getIsDele,"0");
                proApprovalDetailsManager.update(noticeDetailUW);

                //查询该项目是否有未评标的明细
                LambdaQueryWrapper<ProjectApprovalDetails> approvalDetailQW = new LambdaQueryWrapper<>();
                approvalDetailQW.eq(ProjectApprovalDetails::getBidStatus,1)
                        .eq(ProjectApprovalDetails::getNoticeId,entity.getNoticeId())
                        .eq(ProjectApprovalDetails::getIsDele,"0");
                //如果没有，更新项目状态为已评标
                if(proApprovalDetailsManager.count(approvalDetailQW)==0){
                    proNotice.setBidStatus(6);
                    proApprovalManager.updateById(proNotice);
                }
            }

        }

    }

}
