package com.artfess.cgpt.bidding.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotationHistory;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 报价历史记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface BizBiddingQuotationHistoryManager extends BaseManager<BizBiddingQuotationHistory> {

    //通过当前报价表保存报价记录
    boolean saveByQuo(BizBiddingQuotation biddingQuotation);

    //通过当前报价表保存报价记录
    boolean saveByQuoList(List<BizBiddingQuotation> quoList);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotationHistory> queryAllByPage(QueryFilter<BizBiddingQuotationHistory> queryFilter);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<BizBiddingQuotationHistory> queryFilter, HttpServletResponse response) throws IOException;

}
