package com.artfess.cgpt.bidding.dao;

import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 当前报价表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface BizBiddingQuotationDao extends BaseMapper<BizBiddingQuotation> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotation> queryAllByPage(IPage<BizBiddingQuotation> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     * 分页查询数据（包含物资立项明细）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotation> pageMatDetail(IPage<BizBiddingQuotation> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     * 分页查询数据（包含项目立项明细）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotation> pageProDetail(IPage<BizBiddingQuotation> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     * 分页查询数据（包含物资立项明细）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotation> queryGroupOrgByPage(IPage<BizBiddingQuotation> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     * 查询最低报价金额
     * @param convert2Wrapper
     * @return
     */
    BigDecimal getMinPrice(@Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     /**
     * 根据明细分组获取最低报价
     * @param noticeId 立项id
     * @param round 报价轮次
     * @param type 立项类型
     * @return 立项明细id和最低报价的map集合
     */
    @MapKey("hId")
    Map<String, Map<String,String>> getGroupMinPrice(@Param("noticeId")String noticeId,
                                                     @Param("round")String round,
                                                     @Param("type")String type);


    /**
     * 查询报价金额排行
     * @param noticeId
     * @param round
     * @param type
     * @return
     */
    List<BizBiddingQuotation> getRankList(@Param("noticeId")String noticeId,
                                          @Param("noticeDetailId")String noticeDetailId,
                                                     @Param("round")String round,
                                                     @Param("type")String type);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotation> groupOrgQuery(IPage<BizBiddingQuotation> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotation> convert2Wrapper);

    /**
     * 根据公告id查询报价公司评分排名
     * @param noticeId 公告id
     * @return
     */
    List<BizBiddingQuotation> quoRankByNoticeId(@Param("noticeId") String noticeId);

}
