/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.contract.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.contract.manager.ContractCallBackManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizContract/v1/"})
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u8868"})
@ApiGroup(group={"group_biz"})
public class BizContractController
extends BaseController<BizContractManager, BizContract> {
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private ContractCallBackManager contractCallBackManager;

    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<BizContract>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizContract> queryFilter) {
        PageList<BizContract> result = ((BizContractManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageVendorGroup"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u7ec4")
    public CommonResult<PageList<BizContract>> pageVendorGroup(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizContract> queryFilter) {
        PageList<BizContract> result = ((BizContractManager)this.baseService).pageVendorGroup(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageByOrg"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u5f53\u524d\u4f01\u4e1a\u76f8\u5173\u6570\u636e")
    public CommonResult<PageList<BizContract>> queryByOrg(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizContract> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        if (BeanUtils.isEmpty((Object)orgId)) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)new PageList(new ArrayList()));
        }
        queryFilter.addFilter("MAT_COMPANY_ID_", (Object)orgId, QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
        queryFilter.addFilter("VENDOR_ID_", (Object)orgId, QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
        PageList<BizContract> result = ((BizContractManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/saveOrUpdateContr"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u5408\u540c")
    public CommonResult saveOrUpdateEntity(@RequestBody BizContract entity) {
        String id = ((BizContractManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)id);
    }

    @PostMapping(value={"/getById"})
    @ApiOperation(value="M-\u6839\u636eid\u67e5\u8be2")
    public CommonResult<BizContract> getDataById(@RequestParam(value="id") String id) {
        if (BeanUtils.isEmpty((Object)id)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        BizContract result = ((BizContractManager)this.baseService).getDetailById(id);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/removeByIds"})
    @ApiOperation(value="M-\u6839\u636eid\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestBody List<String> ids) {
        if (BeanUtils.isEmpty(ids) || ids.size() <= 0) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        ((BizContractManager)this.baseService).removeData(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="M-\u6839\u636eid\u4fee\u6539\u72b6\u6001")
    public CommonResult updateStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        if (BeanUtils.isEmpty((Object)ids)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        if (BeanUtils.isEmpty((Object)status)) {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u72b6\u6001");
        }
        ((BizContractManager)this.baseService).updateStatusByIds(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)ids);
    }

    @PostMapping(value={"/browseContract"})
    @ApiOperation(value="M-\u6d4f\u89c8\u5408\u540c")
    public CommonResult browseContract(@ApiParam(name="threeContrId", value="\u7b2c\u4e09\u65b9\u5408\u540cid") @RequestParam(value="threeContrId") String threeContrId) {
        if (BeanUtils.isEmpty((Object)threeContrId)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        String result = ((BizContractManager)this.baseService).browseContract(threeContrId);
        return new CommonResult(result);
    }

    @PostMapping(value={"/downBatchContract"})
    @ApiOperation(value="M-\u6279\u91cf\u4e0b\u8f7d\u5408\u540c")
    public CommonResult downBatchContract(@ApiParam(name="threeContrIds", value="\u7b2c\u4e09\u65b9\u5408\u540cid\u96c6\u5408") @RequestBody List<Long> threeContrIds, HttpServletResponse response) {
        if (BeanUtils.isEmpty(threeContrIds) || threeContrIds.size() <= 0) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        ((BizContractManager)this.baseService).downBatchContract(threeContrIds, response);
        return new CommonResult("\u4e0b\u8f7d\u6210\u529f");
    }

    @PostMapping(value={"/createContract"})
    @ApiOperation(value="M-\u751f\u6210\u7535\u5b50\u5408\u540c\u8349\u7a3f")
    public CommonResult createContract(@ApiParam(name="id", value="\u672c\u5730\u5408\u540c\u8868id") @RequestParam(value="id") String id) throws Exception {
        if (BeanUtils.isEmpty((Object)id)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        String result = ((BizContractManager)this.baseService).createContract(id);
        return new CommonResult(result);
    }

    @PostMapping(value={"/sendContract"})
    @ApiOperation(value="M-\u53d1\u8d77\u7535\u5b50\u5408\u540c\u7b7e\u8ba2")
    public CommonResult sendContract(@ApiParam(name="threeContrId", value="\u7b2c\u4e09\u65b9\u5408\u540cid") @RequestParam(value="threeContrId") String threeContrId) throws Exception {
        if (BeanUtils.isEmpty((Object)threeContrId)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        ((BizContractManager)this.baseService).sendContract(threeContrId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="contractId", value="\u6587\u4ef6\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="sn", value="\u6587\u4ef6\u81ea\u5b9a\u4e49\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="status", value="\u6587\u4ef6\u72b6\u6001", dataType="String"), @ApiImplicitParam(name="type", value="\u56de\u8c03\u7c7b\u578b", dataType="String"), @ApiImplicitParam(name="contact", value="\u8054\u7cfb\u65b9\u5f0f", dataType="String"), @ApiImplicitParam(name="operatorName", value="\u64cd\u4f5c\u4eba\u59d3\u540d", dataType="String"), @ApiImplicitParam(name="operatorMobile", value="\u64cd\u4f5c\u4eba\u624b\u673a\u53f7", dataType="String"), @ApiImplicitParam(name="operatorNumber", value="\u64cd\u4f5c\u4eba\u5458\u5de5\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="receiverNumber", value="\u7ecf\u529e\u4eba\u5458\u5de5\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="accessKey", value="ak", dataType="String"), @ApiImplicitParam(name="secretKey", value="sk", dataType="String")})
    @PostMapping(value={"/signingCompleted"})
    @ApiOperation(value="M-\u7b7e\u7f72\u5b8c\u6210\uff08\u5408\u540c\u7cfb\u7edf\u56de\u8c03\u63a5\u53e3\uff09")
    public void signingCompleted(String contractId, String sn, String status, String type, String contact, String operatorName, String operatorMobile, String operatorNumber, String receiverNumber, String accessKey, String secretKey) {
        this.contractCallBackManager.signingCompleted(contractId, sn, status, type, contact, operatorName, operatorMobile, operatorNumber, receiverNumber, accessKey, secretKey, 1);
    }
}

