/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.webSocket.PushService;
import com.artfess.cgpt.bidding.dao.BizBiddingQuotationDao;
import com.artfess.cgpt.bidding.manager.BidEvaluationRecordManager;
import com.artfess.cgpt.bidding.manager.BiddingQuotationTemplateDetailDataManager;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationHistoryManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.vo.QuoVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.ProjectEvaluationExpert;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizBiddingQuotationManagerImpl
extends BaseManagerImpl<BizBiddingQuotationDao, BizBiddingQuotation>
implements BizBiddingQuotationManager {
    @Autowired
    PushService pushService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private BizBiddingQuotationHistoryManager quotationHistoryManager;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager quotationTemplateDetailDataManager;
    @Autowired
    private BidEvaluationRecordManager evaluationRecordManager;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;

    @Override
    public PageList<BizBiddingQuotation> queryAllByPage(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).queryAllByPage((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageQuoAndMatDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).pageMatDetail((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageMatDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        Integer noticeType = 1;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("noticeType") && !qf.getProperty().equals("quo.NOTICE_TYPE_")) continue;
                noticeType = Integer.valueOf(qf.getValue().toString());
            }
        }
        IPage<BizBiddingQuotation> result = null;
        result = noticeType == 1 ? ((BizBiddingQuotationDao)this.baseMapper).pageMatDetail((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : ((BizBiddingQuotationDao)this.baseMapper).pageProDetail((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation s : records) {
                LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)s.getNoticeId())).eq(BidEvaluationRecord::getNoticeDetailedId, (Object)s.getNoticeDetailedId())).eq(BidEvaluationRecord::getQuotationOrgId, (Object)s.getQuotationCompanyId())).orderByDesc(BidEvaluationRecord::getOperateTime)).last("limit 1");
                BidEvaluationRecord evaRecord = (BidEvaluationRecord)((Object)this.evaluationRecordManager.getBaseMapper().selectOne((Wrapper)bidEvaQW));
                if (BeanUtils.isNotEmpty((Object)((Object)evaRecord))) {
                    if (BeanUtils.isNotEmpty((Object)evaRecord.getScore())) {
                        s.setTotalScore(evaRecord.getScore());
                    }
                    s.setIsEva(1);
                    if (BeanUtils.isNotEmpty((Object)evaRecord.getEvaExplain())) {
                        s.setEvaExplain(evaRecord.getEvaExplain());
                        List<Accessory> evaExplainAccessory = this.accessoryService.getAccessoryBySourceId(evaRecord.getId());
                        if (BeanUtils.isNotEmpty(evaExplainAccessory)) {
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                } else {
                    s.setIsEva(0);
                }
                LambdaQueryWrapper templateDataQW = new LambdaQueryWrapper();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)s.getId());
                List templateDataList = this.quotationTemplateDetailDataManager.list((Wrapper)templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageQuoOrg(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).queryGroupOrgByPage((IPage<BizBiddingQuotation>)new Page(0L, -1L, false), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation s : records) {
                LambdaQueryWrapper lastQuoQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lastQuoQW.eq(BizBiddingQuotation::getNoticeId, (Object)s.getNoticeId())).eq(BeanUtils.isNotEmpty((Object)s.getNoticeDetailedId()), BizBiddingQuotation::getNoticeDetailedId, (Object)s.getNoticeDetailedId())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)s.getQuotationCompanyId())).orderByDesc(BizBiddingQuotation::getQuotationTime)).last("limit 1");
                BizBiddingQuotation lastQuo = (BizBiddingQuotation)((Object)((BizBiddingQuotationDao)this.baseMapper).selectOne((Wrapper)lastQuoQW));
                s.setQuotationPrice(lastQuo.getQuotationPrice());
                s.setQuotationAmount(lastQuo.getQuotationAmount());
                LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)s.getNoticeId())).eq(BidEvaluationRecord::getNoticeDetailedId, (Object)s.getNoticeDetailedId())).eq(BidEvaluationRecord::getQuotationOrgId, (Object)s.getQuotationCompanyId())).eq(BidEvaluationRecord::getStatus, (Object)2)).orderByDesc(BidEvaluationRecord::getOperateTime)).last("limit 1");
                BidEvaluationRecord evaRecord = (BidEvaluationRecord)((Object)this.evaluationRecordManager.getBaseMapper().selectOne((Wrapper)bidEvaQW));
                if (BeanUtils.isNotEmpty((Object)((Object)evaRecord))) {
                    if (BeanUtils.isNotEmpty((Object)evaRecord.getScore())) {
                        s.setTotalScore(evaRecord.getScore());
                    }
                    s.setIsEva(1);
                    if (BeanUtils.isNotEmpty((Object)evaRecord.getEvaExplain())) {
                        s.setEvaExplain(evaRecord.getEvaExplain());
                        List<Accessory> evaExplainAccessory = this.accessoryService.getAccessoryBySourceId(evaRecord.getId());
                        if (BeanUtils.isNotEmpty(evaExplainAccessory)) {
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                } else {
                    s.setIsEva(0);
                }
                LambdaQueryWrapper templateDataQW = new LambdaQueryWrapper();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)s.getId());
                List templateDataList = this.quotationTemplateDetailDataManager.list((Wrapper)templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageProDetail(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).pageProDetail((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizBiddingQuotation> pageLowestEva(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).queryAllByPage((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        BigDecimal minPrice = ((BizBiddingQuotationDao)this.baseMapper).getMinPrice((Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation s : records) {
                if (BeanUtils.isNotEmpty((Object)minPrice) && s.getQuotationPrice().compareTo(minPrice) == 0) {
                    s.setIsLowest(1);
                } else {
                    s.setIsLowest(0);
                }
                LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BizBidEvaluation::getQuotationId, (Object)s.getId())).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(BizBidEvaluation::getOperateTime)).last("limit 1");
                BizBidEvaluation bidEvaluation = (BizBidEvaluation)((Object)this.bidEvaluationManager.getBaseMapper().selectOne((Wrapper)bidEvaQW));
                if (BeanUtils.isNotEmpty((Object)((Object)bidEvaluation))) {
                    s.setIsEva(1);
                    if (BeanUtils.isNotEmpty((Object)bidEvaluation.getEvaExplain())) {
                        s.setEvaExplain(bidEvaluation.getEvaExplain());
                        List<Accessory> evaExplainAccessory = this.accessoryService.getAccessoryBySourceId(bidEvaluation.getId());
                        if (BeanUtils.isNotEmpty(evaExplainAccessory)) {
                            s.setEvaExplainAccessory(evaExplainAccessory);
                        }
                    }
                } else {
                    s.setIsEva(0);
                }
                LambdaQueryWrapper templateDataQW = new LambdaQueryWrapper();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)s.getId());
                List templateDataList = this.quotationTemplateDetailDataManager.list((Wrapper)templateDataQW);
                s.setQuotationTemplateDetailDataList(templateDataList);
            }
        }
        return new PageList(result);
    }

    @Override
    public Map<String, Map<String, String>> getGroupMinPrice(String noticeId, String round, String type) {
        return ((BizBiddingQuotationDao)this.baseMapper).getGroupMinPrice(noticeId, round, type);
    }

    @Override
    public List<BizBiddingQuotation> getRankList(String noticeId, String noticeDetailId, String round, String type) {
        return ((BizBiddingQuotationDao)this.baseMapper).getRankList(noticeId, noticeDetailId, round, type);
    }

    @Override
    @Transactional
    public void quoMat(QuoVo quoVo) {
        MatApproval notice = quoVo.getMatApproval();
        List<MatApprovalDetails> detailList = notice.getDetailsList();
        for (MatApprovalDetails detail : detailList) {
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;
            if (BeanUtils.isEmpty((Object)detail.getMyPrice())) {
                detail.setMyPrice(BigDecimal.ZERO);
            }
            if (BeanUtils.isEmpty((Object)detail.getMyAmount())) {
                detail.setMyAmount(BigDecimal.ZERO);
            }
            if (BeanUtils.isNotEmpty(quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList()) && quotationTemplateDetailDataList.size() > 0) {
                List priceCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 1 && BeanUtils.isNotEmpty((Object)s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                List amountCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 2 && BeanUtils.isNotEmpty((Object)s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(priceCollect) && priceCollect.size() > 0) {
                    detail.setMyPrice(new BigDecimal((String)priceCollect.get(0)));
                }
                if (BeanUtils.isNotEmpty((Object)amountCollect) && amountCollect.size() > 0) {
                    detail.setMyAmount(new BigDecimal((String)amountCollect.get(0)));
                }
            }
            if (detail.getMyPrice().compareTo(BigDecimal.ZERO) > 0 && detail.getMyAmount().compareTo(BigDecimal.ZERO) == 0) {
                detail.setMyAmount(detail.getMyPrice().multiply(detail.getMatNum()));
            } else if (detail.getMyPrice().compareTo(BigDecimal.ZERO) == 0 && detail.getMyAmount().compareTo(BigDecimal.ZERO) > 0) {
                detail.setMyPrice(detail.getMyAmount().divide(detail.getMatNum(), 4, 4));
            }
            if (!BeanUtils.isNotEmpty((Object)detail.getMaximumPriceLimit()) || detail.getMaximumPriceLimit().compareTo(BigDecimal.ZERO) == 0 || detail.getMyPrice().compareTo(detail.getMaximumPriceLimit()) <= 0) continue;
            throw new BaseException("\u6807\u7684ID\u3010" + detail.getId() + "\u3011\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u6700\u9ad8\u9650\u4ef7");
        }
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        String bacthNum = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "jpbj_pch");
        ArrayList<BizBiddingQuotation> quoData = new ArrayList<BizBiddingQuotation>();
        for (MatApprovalDetails detail : detailList) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BizBiddingQuotation::getNoticeId, (Object)detail.getNoticeId())).eq(BizBiddingQuotation::getNoticeDetailedId, (Object)detail.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)"1")).eq(BizBiddingQuotation::getQuotationRounds, (Object)notice.getQuotationRoundsNum())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId())).orderByDesc(BizBiddingQuotation::getQuotationTime)).last("limit 1");
            BizBiddingQuotation entity = (BizBiddingQuotation)((Object)((BizBiddingQuotationDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
            if (BeanUtil.isNotEmpty((Object)((Object)entity), (String[])new String[0])) {
                entity.setQuotationBacthNum(bacthNum);
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(LocalDateTime.now());
                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
            } else {
                entity = new BizBiddingQuotation();
                entity.setQuotationRounds(notice.getQuotationRoundsNum());
                entity.setQuotationBacthNum(bacthNum);
                entity.setNoticeId(detail.getNoticeId());
                entity.setNoticeType("1");
                entity.setNoticeDetailedId(detail.getId());
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
                entity.setQuotationCompanyId(org.getGroupId());
                entity.setQuotationCompanyCode(org.getGroupCode());
                entity.setQuotationCompanyName(org.getName());
                Integer userNum = null;
                LocalDateTime now = LocalDateTime.now();
                userNum = now.getHour() + now.getMinute() + now.getSecond();
                entity.setQuotationNum(userNum);
                entity.setMatNum(detail.getMatNum());
                entity.setQuotationMethod(notice.getQuotationMethod());
                entity.setIsTax(notice.getIsTax());
                entity.setTaxRate(detail.getTaxRate());
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(LocalDateTime.now());
                entity.setQuotationTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
            }
            if (BeanUtils.isNotEmpty((Object)detail.getTenderExplain())) {
                entity.setTenderExplain(detail.getTenderExplain());
            } else {
                entity.setTenderExplain(null);
            }
            quoData.add(entity);
            super.saveOrUpdate((Object)entity);
            String quoId = entity.getId();
            LambdaQueryWrapper quoTemplateHisQW = new LambdaQueryWrapper();
            quoTemplateHisQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)quoId);
            this.quotationTemplateDetailDataManager.remove((Wrapper)quoTemplateHisQW);
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if (!BeanUtils.isNotEmpty(quotationTemplateDetailDataList) || quotationTemplateDetailDataList.size() <= 0) continue;
            quotationTemplateDetailDataList.stream().forEach(s -> s.setQuotationId(quoId));
            this.quotationTemplateDetailDataManager.saveBatch(quotationTemplateDetailDataList);
        }
        if (quoData.size() > 0) {
            this.quotationHistoryManager.saveByQuoList(quoData);
        }
        if (notice.getProcureType() == 3) {
            if (BeanUtils.isNotEmpty((Object)quoVo.getAuctionEndDate())) {
                LambdaUpdateWrapper noticeUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(MatApproval::getBiddingEndTime, (Object)quoVo.getAuctionEndDate())).eq(MatApproval::getId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)"0");
                this.matApprovalManager.update((Wrapper)noticeUW);
            }
            HashMap<String, MatApproval> map = new HashMap<String, MatApproval>();
            map.put("quo", quoVo.getMatApproval());
            JSON parse = JSONUtil.parse(map);
            this.pushService.pushMsgToAll(parse.toString());
        }
    }

    @Override
    @Transactional
    public void quoProject(QuoVo quoVo) {
        ProjectApproval notice = quoVo.getProjectApproval();
        List<ProjectApprovalDetails> detailList = notice.getDetailsList();
        for (ProjectApprovalDetails detail : detailList) {
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;
            if (BeanUtils.isEmpty((Object)detail.getMyPrice())) {
                detail.setMyPrice(BigDecimal.ZERO);
            }
            if (BeanUtils.isEmpty((Object)detail.getMyAmount())) {
                detail.setMyAmount(BigDecimal.ZERO);
            }
            if (BeanUtils.isNotEmpty(quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList()) && quotationTemplateDetailDataList.size() > 0) {
                List priceCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 1 && BeanUtils.isNotEmpty((Object)s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                List amountCollect = quotationTemplateDetailDataList.stream().filter(s -> s.getPriceEntry() == 2 && BeanUtils.isNotEmpty((Object)s.getValue())).map(s -> s.getValue()).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(priceCollect) && priceCollect.size() > 0) {
                    detail.setMyPrice(new BigDecimal((String)priceCollect.get(0)));
                }
                if (BeanUtils.isNotEmpty(amountCollect) && amountCollect.size() > 0) {
                    detail.setMyAmount(new BigDecimal((String)amountCollect.get(0)));
                }
            }
            if (detail.getMyPrice().compareTo(BigDecimal.ZERO) > 0 && detail.getMyAmount().compareTo(BigDecimal.ZERO) == 0) {
                detail.setMyAmount(detail.getMyPrice().multiply(detail.getMatNum()));
            } else if (detail.getMyPrice().compareTo(BigDecimal.ZERO) == 0 && detail.getMyAmount().compareTo(BigDecimal.ZERO) > 0) {
                detail.setMyPrice(detail.getMyAmount().divide(detail.getMatNum(), 4, 4));
            }
            if (!BeanUtils.isNotEmpty((Object)detail.getMaximumPriceLimit()) || detail.getMaximumPriceLimit().compareTo(BigDecimal.ZERO) == 0 || detail.getMyPrice().compareTo(detail.getMaximumPriceLimit()) <= 0) continue;
            throw new BaseException("\u6807\u7684ID\u3010" + detail.getId() + "\u3011\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u6700\u9ad8\u9650\u4ef7");
        }
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        String bacthNum = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "jpbj_pch");
        LocalDateTime nowTime = LocalDateTime.now();
        ArrayList<BizBiddingQuotation> quoData = new ArrayList<BizBiddingQuotation>();
        for (ProjectApprovalDetails detail : detailList) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BizBiddingQuotation::getNoticeId, (Object)detail.getNoticeId())).eq(BizBiddingQuotation::getNoticeDetailedId, (Object)detail.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)"2")).eq(BizBiddingQuotation::getQuotationRounds, (Object)notice.getQuotationRoundsNum())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId())).orderByDesc(BizBiddingQuotation::getQuotationTime)).last("limit 1");
            BizBiddingQuotation entity = (BizBiddingQuotation)((Object)((BizBiddingQuotationDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
            if (BeanUtil.isNotEmpty((Object)((Object)entity), (String[])new String[0])) {
                entity.setQuotationBacthNum(bacthNum);
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(nowTime);
                entity.setQuotationTimer(nowTime.toEpochSecond(ZoneOffset.of("+8")));
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
            } else {
                entity = new BizBiddingQuotation();
                entity.setQuotationRounds(notice.getQuotationRoundsNum());
                entity.setQuotationBacthNum(bacthNum);
                entity.setNoticeId(detail.getNoticeId());
                entity.setNoticeType("2");
                entity.setNoticeDetailedId(detail.getId());
                entity.setQuotationUserId(user.getUserId());
                entity.setQuotationUserAccount(user.getAccount());
                entity.setQuotationUserName(user.getFullname());
                entity.setQuotationUserPhone(user.getMobile());
                entity.setQuotationCompanyId(org.getGroupId());
                entity.setQuotationCompanyCode(org.getGroupCode());
                entity.setQuotationCompanyName(org.getName());
                Integer userNum = null;
                userNum = nowTime.getHour() + nowTime.getMinute() + nowTime.getSecond();
                entity.setQuotationNum(userNum);
                entity.setMatNum(detail.getMatNum());
                entity.setQuotationMethod(notice.getQuotationMethod());
                entity.setIsTax(notice.getIsTax());
                entity.setTaxRate(detail.getTaxRate());
                entity.setQuotationPrice(detail.getMyPrice());
                entity.setQuotationAmount(detail.getMyAmount());
                entity.setQuotationTime(nowTime);
                entity.setQuotationTimer(nowTime.toEpochSecond(ZoneOffset.of("+8")));
            }
            if (BeanUtils.isNotEmpty((Object)detail.getTenderExplain())) {
                entity.setTenderExplain(detail.getTenderExplain());
            } else {
                entity.setTenderExplain(null);
            }
            quoData.add(entity);
            super.saveOrUpdate((Object)entity);
            String quoId = entity.getId();
            LambdaQueryWrapper quoTemplateHisQW = new LambdaQueryWrapper();
            quoTemplateHisQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)quoId);
            this.quotationTemplateDetailDataManager.remove((Wrapper)quoTemplateHisQW);
            List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList = detail.getQuotationTemplateDetailDataList();
            if (!BeanUtils.isNotEmpty(quotationTemplateDetailDataList) || quotationTemplateDetailDataList.size() <= 0) continue;
            quotationTemplateDetailDataList.stream().forEach(s -> s.setQuotationId(quoId));
            this.quotationTemplateDetailDataManager.saveBatch(quotationTemplateDetailDataList);
        }
        if (quoData.size() > 0) {
            this.quotationHistoryManager.saveByQuoList(quoData);
        }
        if (notice.getProcureType() == 3) {
            if (BeanUtils.isNotEmpty((Object)quoVo.getAuctionEndDate())) {
                LambdaUpdateWrapper noticeUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(MatApproval::getBiddingEndTime, (Object)quoVo.getAuctionEndDate())).eq(MatApproval::getId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)"0");
                this.matApprovalManager.update((Wrapper)noticeUW);
            }
            HashMap<String, MatApproval> map = new HashMap<String, MatApproval>();
            map.put("quo", quoVo.getMatApproval());
            JSON parse = JSONUtil.parse(map);
            this.pushService.pushMsgToAll(parse.toString());
        }
    }

    @Override
    public MatApproval matBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter) {
        String noticeId = null;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equalsIgnoreCase("noticeId")) continue;
                noticeId = String.valueOf(qf.getValue());
            }
        }
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)noticeId)));
        LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, noticeId)).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        List evaluationExpertList = this.evaluationExpertManager.list((Wrapper)evaluationExpertQW);
        if (BeanUtils.isNotEmpty((Object)evaluationExpertList)) {
            notice.setProjectEvaluationExpertList(evaluationExpertList);
        }
        queryFilter.addFilter("NOTICE_TYPE_", (Object)"1", QueryOP.EQUAL);
        List records = ((BizBiddingQuotationDao)this.baseMapper).groupOrgQuery((IPage<BizBiddingQuotation>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation quo : records) {
                QueryWrapper quoRoundsQW = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)quoRoundsQW.select(new String[]{"QUOTATION_ROUNDS_ as 'quotationRounds',ROUND(SUM(QUOTATION_PRICE_*MAT_NUM_),2) as 'totalPrice'"}).lambda().eq(BizBiddingQuotation::getNoticeId, (Object)quo.getNoticeId())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)quo.getQuotationCompanyId())).groupBy(BizBiddingQuotation::getQuotationRounds);
                List mapList = ((BizBiddingQuotationDao)this.baseMapper).selectMaps((Wrapper)quoRoundsQW);
                quo.setQuoPriceMap(mapList);
            }
        }
        notice.setQuotationList(records);
        return notice;
    }

    @Override
    public ProjectApproval proBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter) {
        String noticeId = null;
        String round = "1";
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equalsIgnoreCase("noticeId")) continue;
                noticeId = String.valueOf(qf.getValue());
            }
        }
        ProjectApproval notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)noticeId)));
        LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, noticeId)).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
        List evaluationExpertList = this.evaluationExpertManager.list((Wrapper)evaluationExpertQW);
        if (BeanUtils.isNotEmpty((Object)evaluationExpertList)) {
            notice.setProjectEvaluationExpertList(evaluationExpertList);
        }
        queryFilter.addFilter("NOTICE_TYPE_", (Object)"2", QueryOP.EQUAL);
        List records = ((BizBiddingQuotationDao)this.baseMapper).groupOrgQuery((IPage<BizBiddingQuotation>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation quo : records) {
                QueryWrapper quoRoundsQW = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)quoRoundsQW.select(new String[]{"QUOTATION_ROUNDS_ as 'quotationRounds',SUM(QUOTATION_PRICE_*MAT_NUM_) as 'totalPrice'"}).lambda().eq(BizBiddingQuotation::getNoticeId, (Object)quo.getNoticeId())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)quo.getQuotationCompanyId())).groupBy(BizBiddingQuotation::getQuotationRounds);
                List mapList = ((BizBiddingQuotationDao)this.baseMapper).selectMaps((Wrapper)quoRoundsQW);
                quo.setQuoPriceMap(mapList);
            }
        }
        notice.setQuotationList(records);
        return notice;
    }

    @Override
    public PageList<BizBiddingQuotation> evaOrgQuoData(QueryFilter<BizBiddingQuotation> queryFilter) {
        IPage<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).groupOrgQuery((IPage<BizBiddingQuotation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBiddingQuotation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBiddingQuotation quo : records) {
                LambdaQueryWrapper evaRecordQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaRecordQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)quo.getNoticeId())).eq(BidEvaluationRecord::getQuotationOrgId, (Object)quo.getQuotationCompanyId())).orderByDesc(BidEvaluationRecord::getOperateTime)).last("limit 1");
                BidEvaluationRecord evaRecord = (BidEvaluationRecord)((Object)this.evaluationRecordManager.getBaseMapper().selectOne((Wrapper)evaRecordQW));
                quo.setIsEva(0);
                if (!BeanUtils.isNotEmpty((Object)((Object)evaRecord))) continue;
                quo.setTotalScore(evaRecord.getScore());
                if (evaRecord.getStatus() != 2) continue;
                quo.setIsEva(1);
            }
        }
        return new PageList(result);
    }

    @Override
    public List<BizBiddingQuotation> evaOrgRankData(String noticeId) {
        List<BizBiddingQuotation> result = ((BizBiddingQuotationDao)this.baseMapper).quoRankByNoticeId(noticeId);
        return result;
    }

    @Override
    public void exportDataToExcel(QueryFilter<BizBiddingQuotation> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u62a5\u4ef7\u8be6\u60c5-\u5bfc\u51fa\u7ed3\u679c";
        List data = this.pageQuoAndMatDetail(queryFilter).getRows();
        if (BeanUtils.isEmpty((Object)data) || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        List payMethodDic = this.sysDictionaryManager.queryDictListItemsByCode("cglx-fkfs");
        List isTaxDic = this.sysDictionaryManager.queryDictListItemsByCode("cglx-sfhsj");
        for (BizBiddingQuotation temp : data) {
            String payMethodStr = BizUtils.getDicValueByCode((List<DictModel>)payMethodDic, temp.getQuotationMethod());
            temp.setQuotationMethodStr(payMethodStr);
            String isTaxStr = BizUtils.getDicValueByCode((List<DictModel>)isTaxDic, temp.getIsTax());
            temp.setIsTaxStr(isTaxStr);
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BizBiddingQuotation.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

