/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectApproval/v1/"})
@Api(tags={"\u9879\u76ee\u91c7\u8d2d\u7acb\u9879"})
@ApiGroup(group={"group_biz"})
public class ProjectApprovalController
extends BaseController<ProjectApprovalManager, ProjectApproval> {
    @Autowired
    UCFeignService ucFeignService;

    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<ProjectApproval>> queryAllByPage(@RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u7ec4\u7ec7\u516c\u53f8\u8fc7\u6ee4\uff09")
    public CommonResult<PageList<ProjectApproval>> queryByPage(@RequestBody QueryFilter<ProjectApproval> queryFilter) {
        BizUtils.addFilterByUserOrgAndRole(queryFilter, this.ucFeignService, "AFFILIATED_ORG_ID_");
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageCurUser"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u5f53\u524d\u7528\u6237\u4e3a\u7acb\u9879\u4eba\u7684\uff09")
    public CommonResult<PageList<ProjectApproval>> pageCurUser(@RequestBody QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("AFFILIATED_USER_ID_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageWinNoticeCurUser"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6210\u4ea4\u7acb\u9879\u6570\u636e\uff08\u5f53\u524d\u7528\u6237\u4e3a\u7acb\u9879\u4eba\u7684\uff09")
    public CommonResult<PageList<ProjectApproval>> pageWinNoticeCurUser(@RequestBody QueryFilter<ProjectApproval> queryFilter) {
        queryFilter.addFilter("AFFILIATED_USER_ID_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/removeByIds"})
    @ApiOperation(value="M-\u6839\u636eid\u96c6\u5408\u5220\u9664\u6570\u636e")
    public CommonResult remove(@RequestBody List<String> ids) {
        ((ProjectApprovalManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e")
    public CommonResult saveOrUpdate(@RequestBody ProjectApproval entity) {
        ProjectApproval result = ((ProjectApprovalManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/uploadTenderDoc"})
    @ApiOperation(value="M-\u4e0a\u4f20\u8865\u9057\u6587\u4ef6")
    public CommonResult uploadTenderDoc(@RequestBody ProjectApproval entity) {
        ((ProjectApprovalManager)this.baseService).uploadTenderDoc(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/getDataById"})
    @ApiOperation(value="M-\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<ProjectApproval> getDataById(@RequestParam(value="id") String id) {
        ProjectApproval result = ((ProjectApprovalManager)this.baseService).getDataById(id);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/modifyBidStatus"})
    @ApiOperation(value="M-\u4fee\u6539\u9879\u76ee\u72b6\u6001")
    public CommonResult modifyBidStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        ((ProjectApprovalManager)this.baseService).modifyBidStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/modifyReleaseStatus"})
    @ApiOperation(value="M-\u4fee\u6539\u53d1\u5e03\u72b6\u6001")
    public CommonResult modifyReleaseStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        ((ProjectApprovalManager)this.baseService).modifyReleaseStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)ids);
    }

    @PostMapping(value={"/modifyCalibraStatus"})
    @ApiOperation(value="M-\u4fee\u6539\u5b9a\u6807\u72b6\u6001")
    public CommonResult modifyCalibraStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        ((ProjectApprovalManager)this.baseService).modifyCalibraStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/signData"})
    @ApiOperation(value="M-\u53c2\u4e0e\u62a5\u540d-\u7acb\u9879\u5206\u9875\u67e5\u8be2", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<PageList<ProjectApproval>> signData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).signData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/quoData"})
    @ApiOperation(value="M-\u6211\u7684\u62a5\u4ef7-\u5206\u9875\u67e5\u8be2", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<PageList<ProjectApproval>> quoData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).quoData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/quoManageData"})
    @ApiOperation(value="M-\u62a5\u4ef7\u7ba1\u7406-\u5206\u9875\u67e5\u8be2", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<PageList<ProjectApproval>> quoManageData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).quoManageData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/bidOpenData"})
    @ApiOperation(value="M-\u5f00\u6807\u7ba1\u7406-\u5206\u9875\u67e5\u8be2", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<PageList<ProjectApproval>> bidOpenData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).bidOpenData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/openingBid"})
    @ApiOperation(value="M-\u5f00\u6807\u7ba1\u7406-\u5f00\u6807")
    public CommonResult openingBid(@RequestBody ProjectApproval entity) {
        ((ProjectApprovalManager)this.baseService).openingBid(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/newRoundQuo"})
    @ApiOperation(value="M-\u5f00\u6807\u7ba1\u7406-\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7")
    public CommonResult newRoundQuo(@RequestBody ProjectApproval entity) {
        ((ProjectApprovalManager)this.baseService).newRoundQuo(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/bidEvaData"})
    @ApiOperation(value="M-\u8bc4\u6807\u7ba1\u7406-\u5206\u9875\u67e5\u8be2", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<PageList<ProjectApproval>> bidEvaData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectApproval> queryFilter) {
        PageList<ProjectApproval> result = ((ProjectApprovalManager)this.baseService).bidEvaData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/releaseWinBidNotice"})
    @ApiOperation(value="M-\u6210\u4ea4\u901a\u77e5-\u53d1\u5e03", notes="", httpMethod="POST")
    public CommonResult releaseWinBidNotice(@RequestParam(value="id") String id) throws Exception {
        ((ProjectApprovalManager)this.baseService).releaseWinBidNotice(id);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/getInfoByIdAndUserId"})
    @ApiOperation(value="M-\u6839\u636eid\u548c\u7528\u6237\u67e5\u8be2\u8be6\u60c5\uff08\u516c\u544a\u53ca\u76f8\u5173\u6587\u4ef6\uff09")
    public CommonResult<ProjectApproval> getInfoByIdAndUserId(@RequestParam(value="id") String id, @RequestParam(value="userId") String userId) {
        ProjectApproval result = ((ProjectApprovalManager)this.baseService).getInfoByIdAndUserId(id, userId);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }
}

