/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v2sdk.http;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class HttpParameter {
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, FileItem> files = new HashMap<String, FileItem>();
    private Map<String, List<FileItem>> listFiles = new HashMap<String, List<FileItem>>();
    private HttpMethod httpMethod;
    private String jsonParams;

    public HttpParameter(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public static HttpParameter httpPostParamers() {
        return new HttpParameter(HttpMethod.POST);
    }

    public static HttpParameter httpGetParamers() {
        return new HttpParameter(HttpMethod.GET);
    }

    public HttpParameter addParam(String key, Object value) {
        if (StringUtils.isNotBlank(key) && value != null) {
            this.params.put(key, String.valueOf(value));
        }
        return this;
    }

    public HttpParameter setParams(Map<String, Object> paramMap) {
        if (paramMap == null) {
            return this;
        }
        Set<Map.Entry<String, Object>> entrySet = paramMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            this.addParam(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpParameter addFile(String name, FileItem file) {
        this.files.put(name, file);
        return this;
    }

    public HttpParameter addListFiles(String name, List<FileItem> fileItems) {
        this.listFiles.put(name, fileItems);
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getQueryString(String charset) throws IOException {
        if (this.params == null || this.params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = this.params.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.isNoneEmpty(name, value = entry.getValue())) continue;
            query.append("&");
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.substring(1);
    }

    public boolean isMultipart() {
        return !this.files.isEmpty() || !this.listFiles.isEmpty();
    }

    public boolean isJson() {
        return this.jsonParams != null && this.jsonParams.length() > 0;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, FileItem> getFiles() {
        return this.files;
    }

    public Map<String, List<FileItem>> getListFiles() {
        return this.listFiles;
    }

    public String getJsonParams() {
        return this.jsonParams;
    }

    public HttpParameter setJsonParams(String jsonParams) {
        this.jsonParams = jsonParams;
        return this;
    }

    public String toString() {
        return "HttpParamers " + JSONUtils.toJson(this);
    }
}

