/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.TemplateService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.template.Template;
import net.qiyuesuo.sdk.bean.template.TemplateGroup;
import net.qiyuesuo.sdk.bean.template.TemplateGroupRequest;
import net.qiyuesuo.sdk.bean.template.TemplateRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class TemplateServiceImpl
implements TemplateService {
    private SDKClient client;

    public TemplateServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public List<Template> list(TemplateRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getTenantId() != null) {
            paramers.addParam("tenantId", String.valueOf(request.getTenantId()));
        }
        if (StringUtils.isNotBlank(request.getTenantName())) {
            paramers.addParam("tenantName", request.getTenantName());
        }
        if (request.getKeyword() != null) {
            paramers.addParam("keyword", request.getKeyword());
        }
        if (request.getStatus() != null) {
            paramers.addParam("status", String.valueOf(request.getStatus()));
        }
        if (request.getCreateTimeFrom() != null) {
            paramers.addParam("createTimeFrom", TimeUtils.format(request.getCreateTimeFrom()));
        }
        if (request.getCreateTimeTo() != null) {
            paramers.addParam("createTimeTo", TimeUtils.format(request.getCreateTimeTo()));
        }
        if (request.getCreateTimeOrder() != null) {
            paramers.addParam("createTimeOrder", request.getCreateTimeOrder());
        }
        if (request.getTitleOrder() != null) {
            paramers.addParam("titleOrder", request.getTitleOrder());
        }
        if (request.getType() != null) {
            paramers.addParam("type", request.getType());
        }
        if (request.getProperty() != null) {
            paramers.addParam("property", request.getProperty());
        }
        if (request.getTags() != null) {
            paramers.addParam("tags", request.getTags());
        }
        paramers.addParam("thumbable", String.valueOf(request.isThumbable()));
        Map<String, Object> result = this.client.doService("/template/list", paramers);
        ArrayList<Template> newlist = new ArrayList();
        try {
            List list = (List)result.get("result");
            newlist = MapUtils.toObjectList(list, Template.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return newlist;
    }

    @Override
    public String viewUrl(Long templateId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("templateId", String.valueOf(templateId));
        Map<String, Object> result = this.client.doService("/template/viewurl", paramers);
        String viewUrl = (String)result.get("url");
        return viewUrl;
    }

    @Override
    public TemplateGroup templateGroup(TemplateGroupRequest request) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            params.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            params.addParam("companyName", request.getCompanyName());
        }
        Map<String, Object> result = this.client.doService("/template/templategroup", params);
        Map templateGroupMap = (Map)result.get("result");
        TemplateGroup templateGroup = null;
        try {
            templateGroup = MapUtils.toObject(templateGroupMap, TemplateGroup.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return templateGroup;
    }

    @Override
    public Template detail(Long templateId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (templateId != null) {
            paramers.addParam("templateId", String.valueOf(templateId));
        }
        Map<String, Object> result = this.client.doService("/template/detail", paramers);
        Map templateMap = (Map)result.get("result");
        Template template = null;
        try {
            template = MapUtils.toObject(templateMap, Template.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return template;
    }

    @Override
    public List<Company> innercompanyTempalteGroup(TemplateGroupRequest request) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/template/templategroup/list", params);
        List companiesMap = (List)result.get("result");
        ArrayList<Company> companies = new ArrayList();
        try {
            companies = MapUtils.toObjectList(companiesMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companies;
    }
}

