/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContactService;
import net.qiyuesuo.sdk.bean.contact.ContactRequest;
import net.qiyuesuo.sdk.bean.contact.CorporateContact;
import net.qiyuesuo.sdk.bean.contact.PersonalContact;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactServiceImpl
implements ContactService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private SDKClient client;

    public ContactServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public PersonalContact addPersonal(ContactRequest request) throws PrivateAppException {
        PersonalContact personalContact;
        Map<String, Object> result = this.client.doServiceWithJson("/contact/person", JSONUtils.toJson(request));
        Map personalContactMap = (Map)result.get("result");
        try {
            personalContact = MapUtils.toObject(personalContactMap, PersonalContact.class);
        }
        catch (Exception e) {
            this.logger.error("\u4e2a\u4eba\u8054\u7cfb\u4eba \u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return personalContact;
    }

    @Override
    public CorporateContact addCorporate(ContactRequest request) throws PrivateAppException {
        CorporateContact corporateContact;
        Map<String, Object> result = this.client.doServiceWithJson("/contact/corporate", JSONUtils.toJson(request));
        Map corporateContactMap = (Map)result.get("result");
        try {
            corporateContact = MapUtils.toObject(corporateContactMap, CorporateContact.class);
        }
        catch (Exception e) {
            this.logger.error("\u4f01\u4e1a\u8054\u7cfb\u4eba \u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return corporateContact;
    }
}

