package com.artfess.cgpt.winbind.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.print.DocFlavor;

/**
 * 成交通知表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizWinBiddingNotice对象", description="成交通知表")
@Data
@TableName("biz_win_bidding_notice")
public class  BizWinBiddingNotice extends BizModel<BizWinBiddingNotice> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "发布人ID")
    @TableField("SEND_USER_ID_")
    private String sendUserId;

    @ApiModelProperty(value = "发布人账号")
    @TableField("SEND_USER_ACCOUNT_")
    private String sendUserAccount;

    @ApiModelProperty(value = "发布人姓名")
    @TableField("SEND_USER_NAME_")
    private String sendUserName;

    @ApiModelProperty(value = "发布人联系方式")
    @TableField("SEND_USER_MOBILE_")
    private String sendUserMobile;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "供应商用户ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "供应商联系方式")
    @TableField("VENDOR_USER_PHONE_")
    private String vendorUserPhone;

    @ApiModelProperty(value = "供应商用户姓名")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "内容")
    @TableField("ESTABLISHMENT_NAME_")
    private String establishmentName;

    @ApiModelProperty(value = "发送时间")
    @TableField("SEND_TIME_")
    private LocalDateTime sendTime;

    @ApiModelProperty(value = "确认时间")
    @TableField("CONFIRM_TIME_")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "状态（1：已发布（已确认），2：待确认，3：草稿，4：不同意）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "采购类型（1：公开招标，2：询比价，3：限时竞价，" +
            "4：份额采购（谈判），5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField("PROCURE_TYPE_")
    private Integer procureType;

    @ApiModelProperty(value = "成交通知明细集合")
    @TableField(exist = false)
    private List<BizWinBiddingNoticeDetaile> winBiddingNoticeDetailList;

    @ApiModelProperty(value = "公示有效期")
    @TableField("VALIDITY_DATE_")
    private LocalDate validityDate;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("APPLICATION_ID_")
    private String applicationId;

    @ApiModelProperty(value = "拟定采购预算总金额(元)")
    @TableField("DRAFT_TOTAL_AMOUNT_")
    private BigDecimal draftTotalAmount;


    @ApiModelProperty(value = "采购公司联系人")
    @TableField("PROCURE_CONTACT_")
    private String procureContact;

    @ApiModelProperty(value = "采购公司联系方式")
    @TableField("PROCURE_PHONE_")
    private String procurePhone;

    @ApiModelProperty(value = "采购公司联系地址")
    @TableField("PROCURE_ADDRESS_")
    private String procureAddress;

    @ApiModelProperty(value = "供应商联系地址")
    @TableField("VENDOR_ADDRESS_")
    private String vendorAddress;

    @ApiModelProperty(value = "是否代采（0.否，1.是），默认0")
    @TableField("IS_AGENCY_PROCURE_")
    private Integer isAgencyProcure;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
