package com.artfess.cgpt.winbind.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.vo.BiddingNoticeVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 成交通知表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */

@RestController
@RequestMapping("/bizWinBiddingNotice/v1/")
@Api(tags = "成交通知表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizWinBiddingNoticeController extends BaseController<BizWinBiddingNoticeManager, BizWinBiddingNotice> {

    @Resource
    private UCFeignService ucFeignService;

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizWinBiddingNotice>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNotice> queryFilter){
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        PageList<BizWinBiddingNotice> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据（当前采购商）")
    public CommonResult<PageList<BizWinBiddingNotice>> queryByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNotice> queryFilter){
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new CommonResult<>(true,"查询成功",new PageList<>());
        }
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        queryFilter.addFilter("PROCURE_ORG_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");
        PageList<BizWinBiddingNotice> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/vendorPage")
    @ApiOperation(value = "M-分页查询数据（当前供应商）")
    public CommonResult<PageList<BizWinBiddingNotice>> vendorPage(@RequestBody QueryFilter<BizWinBiddingNotice> queryFilter){
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new CommonResult<>(true,"查询成功",new PageList<>());
        }
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        queryFilter.addFilter("VENDOR_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
//        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"VENDOR_ID_");
        PageList<BizWinBiddingNotice> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }


    @PostMapping("/winBidPage")
    @ApiOperation(value = "M-分页查询数据（当前采购商或供应商）")
    public CommonResult<PageList<BizWinBiddingNotice>> winBidPage(@RequestBody QueryFilter<BizWinBiddingNotice> queryFilter){
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new CommonResult<>(true,"查询成功",new PageList<>());
        }
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        queryFilter.addFilter("PROCURE_ORG_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
        queryFilter.addFilter("VENDOR_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
        PageList<BizWinBiddingNotice> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/queryWinBidVendor")
    @ApiOperation(value = "M-去重查询成交供应商")
    public CommonResult<PageList<BizWinBiddingNotice>> queryWinBidVendor(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNotice> queryFilter){
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new CommonResult<>(true,"查询成功",new PageList<>(new ArrayList<BizWinBiddingNotice>()));
        }
        PageList<BizWinBiddingNotice> result = baseService.getWinBidVendor(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizWinBiddingNotice> selectOne(@RequestParam("id") String id){
        BizWinBiddingNotice result = baseService.getDetailById(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/removeIdList")
    @ApiOperation(value = "M-根据id批量删除")
    public CommonResult removeIdList(@RequestBody List<String> ids){
        if(BeanUtils.isEmpty(ids) || ids.size()<=0){
            throw new BaseException("请选择数据");
        }
        baseService.removeIdList(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation(value = "M-保存或更新")
    public CommonResult saveOrUpdateEntity(@RequestBody BizWinBiddingNotice entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/updateStatusById")
    @ApiOperation(value = "M-更新状态")
    public CommonResult updateStatusById(@RequestParam("id") String id,@RequestParam("status") Integer status){
        baseService.updateStatus(id,status);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/pushWinBidNotice")
    @ApiOperation(value = "M-发布成交通知（物资）")
    public CommonResult pushWinBidNotice(@RequestBody BizWinBiddingNotice entity){
         baseService.pushWinBidNotice(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/pushWinBidNoticePro")
    @ApiOperation(value = "M-发布成交通知（项目）")
    public CommonResult pushWinBidNoticePro(@RequestBody BizWinBiddingNotice entity){
        baseService.pushWinBidNoticePro(entity);
        return new CommonResult(true,"操作成功");
    }

}
