package com.artfess.cgpt.violate.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.violate.vo.ViolateRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.checkerframework.framework.qual.RequiresQualifier;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;

import java.util.List;

/**
 * 竞价违约记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */

@RestController
@RequestMapping("/bizViolateRecord/v1/")
@Api(tags = "竞价违约记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizViolateRecordController extends BaseController<BizViolateRecordManager, BizViolateRecord> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizViolateRecord>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizViolateRecord> queryFilter){
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        PageList<BizViolateRecord> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<ViolateRecordVo> selectOne(@RequestParam String id){
        ViolateRecordVo result=baseService.getDetail(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/refuse")
    @ApiOperation(value = "S-不执行")
    public CommonResult refuse(@RequestBody ViolateRecordVo recordVo){
        baseService.refuse(recordVo);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/updateHandleStatus")
    @ApiOperation(value = "M-更新处理状态")
    public CommonResult updateHandleStatus(@RequestParam("id") String id,
                                           @RequestParam("status") Integer status,
                                           @RequestParam("type") Integer type){
        baseService.updateHandleStatus(id,status,type);
        return new CommonResult<>(true,"操作成功");
    }

}
