package com.artfess.cgpt.taskcallback;

import com.artfess.base.exception.BaseException;
import com.artfess.base.groovy.IScript;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * 某些流程节点执行完后的回调方法
 */
@Component
public class TaskCallBackScript implements IScript {

    @Autowired
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizContractManager contractManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;

    /**
     * 采购合同审核完成
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateContractStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //采购合同审核完成，修改采购合同表状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行采购合同审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行采购合同审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }
        contractManager.updateStatusByIds(businessKey,"5");
    }


    /**
     * 资质审核完成
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateQualificationStatusById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //资质审核完成，修改资质库状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行资质审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行资质审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }
        qualificationLabelManager.updateApprovalStatusById(businessKey,"3");
    }

    /**
     * 采购申请审核完成
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updatePurApplicationStatusById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //采购申请审核完成，修改采购申请表状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行采购申请审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行采购申请审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }
        purchasingApplicationManager.modifyStatusById(businessKey,"3");
    }

    /**
     * 采购立项审核完成
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateMatApprovalReleaseStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //采购立项审核完成，修改采购立项表状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行采购立项审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行采购立项审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }
        if(matApprovalManager.getNoticeTypeById(businessKey)==1){
            //物资
            matApprovalManager.modifyReleaseStatus(businessKey,"2");
        }else {
            //项目
            projectApprovalManager.modifyReleaseStatus(businessKey,"2");
        }

    }

    /**
     * 定标审核完成
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateMatApprovalCalibraStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //定标审核完成，修改采购立项表定标状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行定标审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行定标审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }

        if(matApprovalManager.getNoticeTypeById(businessKey)==1){
            //物资
            matApprovalManager.modifyCalibraStatus(businessKey,"2");
        }else {
            //项目
            projectApprovalManager.modifyCalibraStatus(businessKey,"2");
        }

    }

    /**
     * 有资质报名审核完成，修改参与表状态
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateUserParticipationById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //有资质报名审核完成，修改参与表状态
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************执行有资质报名审核完成回调函数****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************执行有资质报名审核完成回调函数****************************************************");
        if(StringUtils.isBlank(businessKey)) {
            return;
        }
        UserParticipation userParticipation = userParticipationManager.getById(businessKey);
        if(BeanUtils.isNotEmpty(userParticipation.getPrice()) && userParticipation.getPrice().compareTo(BigDecimal.ZERO)>0){
            //如果有保证金，设置状态为待支付
            userParticipation.setStatus(3);
        }else {
            //如果没有保证金，设置状态为已参与
            userParticipation.setStatus(1);
        }

        //更新标书费记录状态
        if(BeanUtils.isNotEmpty(userParticipation.getDocumentFeeId())){
            UserParticipation docPart = userParticipationManager.getById(userParticipation.getDocumentFeeId());
            if(BeanUtils.isNotEmpty(docPart)){
                if(docPart.getPrice().compareTo(BigDecimal.ZERO)>0){
                    //设置状态为待支付
                    docPart.setStatus(3);
                    if(userParticipation.getPrice().compareTo(BigDecimal.ZERO)==0){
                        userParticipation.setStatus(4);
                    }
                }else {
                    //如果金额为0，设置状态为已参与
                    docPart.setStatus(1);
                }
                userParticipationManager.updateById(docPart);
            }

        }

        userParticipationManager.updateById(userParticipation);
    }

    /**
     * 流程后置事件，生成门户已办任务
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void completeTaskToMh(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String proInstId = cmd.getInstId();
        System.out.println("************************************************执行流程后置推送回调函数****************************************************");
        if(StringUtils.isBlank(proInstId)){
            return;
        }
        foreignCallService.completeTaskToMh(proInstId);
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter() {
            @Override
            public void afterCommit() {
                try {
                    createPorTask(cmd);
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException("流程回调失败："+e.getMessage());
                }
            }
        });
    }

    /**
     * 根据taskId创建待办事项
     * @param cmd
     * @throws Exception
     */
    public void createPorTask(ActionCmd cmd) throws Exception {
        List<String> taskIds = bpmProcessInstanceManager.getBpmTaskIdByInstId(cmd.getInstId());
        if(BeanUtils.isNotEmpty(taskIds) && taskIds.size()>0){
            for(String taskId : taskIds){
                foreignCallService.pushTaskToMhByTaskId(taskId);
            }
        }
    }

}
