package com.artfess.cgpt.sysfile.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 标准字段表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizSysField对象", description="标准字段表")
public class BizSysField extends BaseModel<BizSysField> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(String createDeptId) {
        this.createDeptId = createDeptId;
    }
    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateDeptId() {
        return updateDeptId;
    }

    public void setUpdateDeptId(String updateDeptId) {
        this.updateDeptId = updateDeptId;
    }
    public String getUpdateDeptName() {
        return updateDeptName;
    }

    public void setUpdateDeptName(String updateDeptName) {
        this.updateDeptName = updateDeptName;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSysField{" +
            "id=" + id +
            ", remarks=" + remarks +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptId=" + updateDeptId +
            ", updateDeptName=" + updateDeptName +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
