package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Description:准入供应商审核记录表
 * @Author: Rong Tao
 * @Date: 2024/6/19 17:44
 */
@ApiModel(value="SupplierEnterpriseAuditing对象", description="准入供应商审核记录表")
@TableName("biz_supplier_enterprise_auditing")
@Data
public class SupplierEnterpriseAuditing extends BizNoModel<SupplierEnterpriseAuditing> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入供应商表ID")
    @TableField("ADMITTED_SUPPLIER_ID_")
    private String admittedSupplierId;

    @ApiModelProperty(value = "类型（1.准入供应商，2.临时供应商）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "审核结果（0：驳回，1.通过），默认1")
    @TableField("REVIEW_RESULT_")
    private Integer reviewResult;

    @ApiModelProperty(value = "驳回原因")
    @TableField("REJECTION_REASON_")
    private String rejectionReason;

    @ApiModelProperty(value = "审核人")
    @TableField("REVIEWER_ID_")
    private String reviewerId;

    @ApiModelProperty(value = "审核人姓名")
    @TableField("REVIEWER_NAME_")
    private String reviewerName;

    @ApiModelProperty(value = "审核时间")
    @TableField("REVIEW_TIME_")
    private LocalDateTime reviewTime;

}
