package com.artfess.cgpt.supplier.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商分类评级标准表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@ApiModel(value="BizSupplierTypeEvaluation对象", description="供应商分类评级标准表")
@Data
public class BizSupplierTypeEvaluation extends BaseModel<BizSupplierTypeEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商分类表ID（关联供应商分类表ID）")
    @TableField("SUPPLIER_TYPE_ID_")
    private String supplierTypeId;

    @ApiModelProperty(value = "评分方（1：企业方，2：运营方）")
    @TableField("EVALUATION_DIMENSION_")
    private Integer evaluationDimension;

    @ApiModelProperty(value = "评分类型（使用字典）")
    @TableField("EVALUATION_TYPE_")
    private Integer evaluationType;

    @ApiModelProperty(value = "评分项目")
    @TableField("EVALUATION_ITEM_")
    private String evaluationItem;

    @ApiModelProperty(value = "评分标准")
    @TableField("EVALUATION_STANDARD_")
    private String evaluationStandard;

    @ApiModelProperty(value = "分值")
    @TableField("EVALUATION_SCORE_")
    private Integer evaluationScore;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @JsonIgnore
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @JsonIgnore
    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @JsonIgnore
    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @JsonIgnore
    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @JsonIgnore
    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @JsonIgnore
    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @JsonIgnore
    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @JsonIgnore
    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @JsonIgnore
    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @JsonIgnore
    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @JsonIgnore
    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @JsonIgnore
    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @JsonIgnore
    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @JsonIgnore
    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @Override
    public String toString() {
        return "BizSupplierTypeEvaluation{" +
            "id=" + id +
            ", supplierTypeId=" + supplierTypeId +
            ", evaluationDimension=" + evaluationDimension +
            ", evaluationType=" + evaluationType +
            ", evaluationItem=" + evaluationItem +
            ", evaluationStandard=" + evaluationStandard +
            ", evaluationScore=" + evaluationScore +
            ", sn=" + sn +
            ", remarks=" + remarks +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptId=" + updateDeptId +
            ", updateDeptName=" + updateDeptName +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
