package com.artfess.cgpt.supplier.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商_分类中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizSupplierOrgSupplierType对象", description="供应商_分类中间表")
@TableName("biz_supplier_org_supplier_type")
@Data
public class BizSupplierOrgSupplierType extends BaseModel<BizSupplierOrgSupplierType> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商分类ID（关联供应商分类表ID）")
    @TableField("SUPPLIER_TYPE_ID_")
    private String supplierTypeId;

    @ApiModelProperty(value = "供应商ID（关联供应商表ID）")
    @TableField("SUPPLIER_ORG_ID_")
    private String supplierOrgId;

}
