package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:准入配置表
 * @Author: Rong Tao
 * @Date: 2024/7/6 10:46
 */
@ApiModel(value="AdmissionConfig对象", description="准入配置表")
@TableName("biz_admission_config")
@Data
public class AdmissionConfig extends BizNoModel<AdmissionConfig> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "规则编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "规则名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "企业ID（关联组织表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "添加人ID")
    @TableField("ADD_USER_ID_")
    private String addUserId;

    @ApiModelProperty(value = "添加人姓名")
    @TableField("ADD_USER_NAME_")
    private String addUserName;

    @ApiModelProperty(value = "添加时间")
    @TableField("ADD_TIME_")
    private LocalDateTime addTime;

    @ApiModelProperty(value = "物料分类ID（关联物料分类表ID）")
    @TableField("MAT_CATEGORY_ID_")
    private String matCategoryId;

    @ApiModelProperty(value = "物料分类编码")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料分类名称")
    @TableField("MAT_CATEGORY_NAME_")
    private String matCategoryName;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "供应商分类ID")
    @TableField("VENDOR_CATEGORY_ID_")
    private String vendorCategoryId;

    @ApiModelProperty(value = "供应商分类编码")
    @TableField("VENDOR_CATEGORY_CODE_")
    private String vendorCategoryCode;

    @ApiModelProperty(value = "供应商分类名称")
    @TableField("VENDOR_CATEGORY_NAME_")
    private String vendorCategoryName;

    @ApiModelProperty(value = "供应商级别（1：A级，2：B级，3：C级，4：D级）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "准入配置资质要求集合")
    @TableField(exist = false)
    private List<AdmissionConfigQualification> configQualificationList;

    @ApiModelProperty(value = "资质类型集合")
    @TableField(exist = false)
    private List<BizQualificationCategory> qualificationCategoryList;

}
