package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.DataSharingDao;
import com.artfess.cgpt.supplier.manager.DataSharingDetailManager;
import com.artfess.cgpt.supplier.manager.DataSharingManager;
import com.artfess.cgpt.supplier.model.DataSharing;
import com.artfess.cgpt.supplier.model.DataSharingDetail;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:28
 */
@Service
public class DataSharingManagerImpl extends BaseManagerImpl<DataSharingDao, DataSharing> implements DataSharingManager {

    @Autowired
    private DataSharingDetailManager dataSharingDetailManager;

    @Override
    public PageList<DataSharing> queryByPage(QueryFilter<DataSharing> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<DataSharing> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(DataSharing entity) {
        List<DataSharingDetail> detailList = entity.getDetailList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            LambdaQueryWrapper<DataSharingDetail> detailQW = new LambdaQueryWrapper<>();
            detailQW.eq(DataSharingDetail::getDataSharingId,entity.getId());
            dataSharingDetailManager.remove(detailQW);
        }

        IGroup group = ContextUtil.getCurrentGroup();
        entity.setOrgId(group.getGroupId());
        entity.setOrgCode(group.getGroupCode());
        entity.setOrgName(group.getName());

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.forEach(s->s.setDataSharingId(entity.getId()));
            dataSharingDetailManager.saveBatch(detailList);
        }

    }

    @Override
    public DataSharing getDataById(String id) {
        DataSharing result = super.getById(id);
        QueryFilter<DataSharingDetail> detailQF = QueryFilter.build();
        detailQF.setPageBean(new PageBean(0,-1,false));
        detailQF.addFilter("a.DATA_SHARING_ID_",id,QueryOP.EQUAL);
        List<DataSharingDetail> detailList = dataSharingDetailManager.queryAllByPage(detailQF).getRows();
        result.setDetailList(detailList);
        return result;
    }

    @Override
    public List<String> getBizIdsByOrg(String orgId) {
        return baseMapper.getBizIdsByOrgId(orgId);
    }

    @Override
    @Transactional
    public void removeByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        super.removeByIds(idList);
        LambdaQueryWrapper<DataSharingDetail> detailQW = new LambdaQueryWrapper<>();
        detailQW.in(DataSharingDetail::getDataSharingId,idList);
        dataSharingDetailManager.remove(detailQW);
    }

}
