package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeEvaluationManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.artfess.cgpt.supplier.dao.BizSupplierTypeDao;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.model.BizSupplierTypeEvaluation;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.sysConfig.persistence.model.SysActuator;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商分类 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizSupplierTypeManagerImpl extends BaseManagerImpl<BizSupplierTypeDao, BizSupplierType> implements BizSupplierTypeManager {

    @Autowired
    private SystemConfigFeignService systemConfigFeignService;

    @Autowired
    private BizSupplierTypeEvaluationManager bizSupplierTypeEvaluationManager;

    @Override
    public PageList<BizSupplierType> queryAllByPage(QueryFilter<BizSupplierType> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizSupplierType> Ipage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(Ipage);
    }

    @Override
    public void saveOrUpdateEntity(BizSupplierType entity) {
        List<BizSupplierTypeEvaluation> typeEvaluationList = entity.getBizSupplierTypeEvaluationLists();

//        if(BeanUtils.isEmpty(entity.getSn())){
//            entity.setSn(getNextSequence(new HashMap<>()));
//        }

        if(BeanUtils.isEmpty(entity.getId()) && BeanUtils.isEmpty(entity.getCode())){
            entity.setCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"gysfl_flbm"));
        }

        if(BeanUtils.isNotEmpty(entity.getId())){
            LambdaQueryWrapper<BizSupplierTypeEvaluation> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BizSupplierTypeEvaluation::getSupplierTypeId, entity.getId());
            bizSupplierTypeEvaluationManager.remove(queryWrapper);
        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(typeEvaluationList) && typeEvaluationList.size() > 0){
            typeEvaluationList.stream().forEach(e->{
                e.setSupplierTypeId(entity.getId());
//                Map map = new HashMap<String, String>();
//                map.put("SUPPLIER_TYPE_ID_", entity.getId());
//                e.setSn(getNextSequence(map));
            });
            bizSupplierTypeEvaluationManager.saveBatch(typeEvaluationList);
        }
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        super.removeByIds(ids);
        LambdaQueryWrapper<BizSupplierTypeEvaluation> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(BizSupplierTypeEvaluation::getSupplierTypeId, ids);
        bizSupplierTypeEvaluationManager.remove(queryWrapper);
    }

    @Override
    @Transactional
    public boolean updateSequence(HashMap<String, Object> params) {
        Assert.notNull(params, "参数不能为空！");
        for (String key : params.keySet()) {
            UpdateWrapper<BizSupplierType> updateWrapper = new UpdateWrapper<>();
            updateWrapper.set("SN_",params.get(key)).eq("ID_",key);
            this.update(updateWrapper);
        }
        return true;
    }
}
