package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.artfess.cgpt.supplier.model.BizSupplierTypeEvaluation;
import com.artfess.cgpt.supplier.dao.BizSupplierTypeEvaluationDao;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeEvaluationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.HashMap;

/**
 * 供应商分类评级标准表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@Service
public class BizSupplierTypeEvaluationManagerImpl extends BaseManagerImpl<BizSupplierTypeEvaluationDao, BizSupplierTypeEvaluation> implements BizSupplierTypeEvaluationManager {

    @Override
    @Transactional
    public boolean updateSequence(HashMap<String, Object> params) {
        Assert.notNull(params, "参数不能为空！");
        for (String key : params.keySet()) {
            UpdateWrapper<BizSupplierTypeEvaluation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.set("SN_",params.get(key)).eq("ID_",key);
            this.update(updateWrapper);
        }
        return true;
    }

    @Override
    public void saveOrUpdateEntity(BizSupplierTypeEvaluation entity) {
        super.saveOrUpdate(entity);
    }

}
