package com.artfess.cgpt.supplier.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.uc.model.Org;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/6 10:05
 */
public interface EnterpriseManager extends BaseManager<Enterprise> {

    /**
     * 分页查询未添加占用供应商的企业
     * @param queryFilter
     * @return
     */
    PageList<Org> queryOrgNoOccupy(QueryFilter<Enterprise> queryFilter);

    /**
     * 分页查询所有组织（企业表联查）
     * @param queryFilter
     * @return
     */
    PageList<Org> queryAllOrg(QueryFilter<Enterprise> queryFilter);

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<Enterprise> queryByPage(QueryFilter<Enterprise> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     * @return
     */
    void saveOrUpdateEntity(Enterprise entity);

    /**
     * 保存或更新数据（api）
     * @param param
     * @return
     */
    Response saveOrUpdateByApi(JSONObject param);

    /**
     * 保存或更新用户（api）
     * @param param
     * @return
     */
    Response saveOrUpdateUserByApi(JSONObject param);

    /**
     * 根据组织id或编号查询企业信息
     * @param orgId 组织id
     * @return
     */
    Enterprise getByOrgIdOrCode(String orgId,String orgCode);

    /**
     * 根据企业编号或历史企业编号查询企业信息
     * @param code
     * @return
     */
    Enterprise getByCodeOrHisCode(String code);

}
