package com.artfess.cgpt.supplier.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.artfess.base.manager.BaseManager;

import java.util.HashMap;
import java.util.List;

/**
 * 供应商分类 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizSupplierTypeManager extends BaseManager<BizSupplierType> {

    PageList<BizSupplierType> queryAllByPage(QueryFilter<BizSupplierType> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(BizSupplierType entity);

    /**
     * 批量删除数据
     * @param ids
     */
    void removeByIds( List<String> ids);

    /**
     * @Description: 批量修改排序号
     * @Param: params
     * @Return: java.lang.String
     * @Author: ZQF
     * @Date: 2021/3/2
     */
    boolean updateSequence(HashMap<String, Object> params);
}
