package com.artfess.cgpt.supplier.dao;

import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/11 10:57
 */
public interface AdmissionConfigQualificationDao extends BaseMapper<AdmissionConfigQualification> {

    IPage<AdmissionConfigQualification> queryAllByPage(IPage<AdmissionConfigQualification> convert2IPage, @Param("ew") Wrapper<AdmissionConfigQualification> convert2Wrapper);

    /**
     *  根据准入配置id查询资质类型
     * @param configId 准入配置id
     * @return
     */
    List<BizQualificationCategory> getQualificationCategoryByConfigId(@Param("configId")String configId);

}
