package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.SupplierEvaluationDetailManager;
import com.artfess.cgpt.supplier.model.BizSupplierEvaluation;
import com.artfess.cgpt.supplier.model.SupplierEvaluationDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:供应商评价明细表
 * @Author: Rong Tao
 * @Date: 2024/6/20 18:19
 */
@RestController
@RequestMapping("/supplier/evaluationDetail/v1/")
@Api(tags="供应商评价明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class SupplierEvaluationDetailController extends BaseController<SupplierEvaluationDetailManager, SupplierEvaluationDetail> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<SupplierEvaluationDetail>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<SupplierEvaluationDetail> queryFilter){
        PageList<SupplierEvaluationDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
