package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;

/**
 * 准入供应商资质信息表，供应商_资质库中间表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizSupplierOrgQualificationLabel/v1/")
@Api(tags="准入供应商资质信息表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierOrgQualificationLabelController extends BaseController<BizSupplierOrgQualificationLabelManager, BizSupplierOrgQualificationLabel> {

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询所有数据")
    public PageList<BizSupplierOrgQualificationLabel> queryByEnterprise(@RequestBody QueryFilter<BizSupplierOrgQualificationLabel> queryFilter) {
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryQualification")
    @ApiOperation("分页查询所有数据")
    public PageList<BizQualificationLabel> queryQualification(@RequestBody QueryFilter<BizSupplierOrgQualificationLabel> queryFilter) {
        return baseService.queryQualificationPage(queryFilter);
    }

}
