package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgSupplierTypeManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierOrgSupplierType;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgManager;

import java.util.ArrayList;
import java.util.List;

/**
 * 企业表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizSupplierOrg/v1/")
@Api(tags="企业表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierOrgController extends BaseController<BizSupplierOrgManager, BizSupplierOrg> {
    @Autowired
    private BizSupplierOrgSupplierTypeManager bizSupplierOrgSupplierTypeManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager bizSupplierOrgQualificationLabelManager;

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizSupplierOrg>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizSupplierOrg> queryFilter){
        PageList<BizSupplierOrg> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @RequestMapping(value = "/saveSupplierOrg", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-添加或修改企业")
    public CommonResult<List<BizSupplierOrg>> saveSupplierOrg(@RequestBody BizSupplierOrg entity) {
//        boolean admin = BizUtils.isAdmin(ucFeignService);
        entity.setIsDele("0");
        baseService.saveOrUpdate(entity);
        List<BizSupplierType> supplierTypeList = entity.getSupplierTypeList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        List<BizSupplierOrgSupplierType> list=new ArrayList<>();
        for(BizSupplierType s:supplierTypeList){
            BizSupplierOrgSupplierType model=new BizSupplierOrgSupplierType();
            model.setSupplierOrgId(entity.getId());
            model.setSupplierTypeId(s.getId());
            list.add(model);
        }
//        List<BizSupplierOrgQualificationLabel> list1=new ArrayList<>();
//        for(BizQualificationLabel s:qualificationLabelList){
//            BizSupplierOrgQualificationLabel model=new BizSupplierOrgQualificationLabel();
//            model.setSupplierOrgId(entity.getId());
//            model.setQualificationLabelId(s.getId());
//            list1.add(model);
//        }
        bizSupplierOrgSupplierTypeManager.saveBatch(list);
//        bizSupplierOrgQualificationLabelManager.saveBatch(list1);
        String message = "操作成功";
        return new CommonResult<>(true, message);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizSupplierOrg> selectOne(@RequestParam String supplierId){
//        BizExpertDatabase result=baseService.getExpertById(id);
        BizSupplierOrg result = baseService.getById(supplierId);
        //查询企业分类
        List<BizSupplierType> orgSupplierTypes=baseService.querySupplierType(supplierId);
        //查询企业资质信息
        List<BizQualificationLabel> queryQualifications=  baseService.queryQualification(supplierId);
        result.setSupplierTypeList(orgSupplierTypes);
        result.setQualificationLabelList(queryQualifications);
        return new CommonResult<>(true,"查询成功",result);
    }
}
