package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizDeliveryAddress;
import com.artfess.cgpt.supplier.manager.BizDeliveryAddressManager;


/**
 * 送货地址管理表 前端控制器
 *
 * @author wsf
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-06-21
 */
@RestController
@RequestMapping("/bizDeliveryAddress/v1")
@Api(tags = "送货地址管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizDeliveryAddressController extends BaseController<BizDeliveryAddressManager, BizDeliveryAddress> {

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody BizDeliveryAddress entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping(value="/queryByPageOrg")
    @ApiOperation("分页查询数据（当前公司过滤）")
    public PageList<BizDeliveryAddress> queryByPage(@RequestBody QueryFilter<BizDeliveryAddress> queryFilter) {
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            PageBean pageBean = queryFilter.getPageBean();
            return new PageList<>(new Page(pageBean.getPage(), pageBean.getPageSize(), pageBean.showTotal()));
        }
        queryFilter.addFilter("ENTERPRISE_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.query(queryFilter);
    }

}
