package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.supplier.manager.AdmissionConfigManager;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/6 11:01
 */
@RestController
@RequestMapping("/admissionConfig/v1/")
@Api(tags="准入配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AdmissionConfigController extends BaseController<AdmissionConfigManager, AdmissionConfig> {

    @Autowired
    UCFeignService ucFeignService;

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody AdmissionConfig entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/saveOrUpdateList")
    @ApiOperation("批量保存或更新数据")
    public CommonResult saveOrUpdateList(@RequestBody List<AdmissionConfig> data) {
        baseService.saveOrUpdateEntity(data);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/removeByIds")
    @ApiOperation("根据id删除数据")
    public CommonResult removeByIds(@RequestParam("ids") String ids) {
        baseService.removeByIds(ids);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询数据")
    public PageList<AdmissionConfig> queryByPage(@RequestBody QueryFilter<AdmissionConfig> queryFilter) {
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new PageList<>();
        }
        queryFilter.addFilter("ENTERPRISE_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
//        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"ENTERPRISE_ID_");
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryQuaCategory")
    @ApiOperation("分页查询数据（包含资质分类）")
    public PageList<AdmissionConfig> queryQuaCategory(@RequestBody QueryFilter<AdmissionConfig> queryFilter) {
//        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"ENTERPRISE_ID_");
        return baseService.queryQuaCategory(queryFilter);
    }

    @PostMapping("/getDetailById")
    @ApiOperation(value = "M-根据id查询")
    public CommonResult<AdmissionConfig> getDetailById(@RequestParam("id") String id) {
        AdmissionConfig result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }


}
