package com.artfess.cgpt.sso.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 单点登录系统配置
 *
 * @author chens
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-12-02
 */
@Data
@TableName("biz_sso_system")
@ApiModel(value = "BizSsoSystem对象", description = "单点登录系统配置")
public class SsoSystem extends BizNoModel<SsoSystem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "所属单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "联系人")
    @TableField("CONTACT_")
    private String contact;

    @ApiModelProperty(value = "联系电话")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "是否限制IP（0：否【默认】，1：是）")
    @TableField("IS_IP_ASTRICT_")
    private Integer isIpAstrict;

    @ApiModelProperty(value = "限制的IP地址，多个以英文,隔开(限制的IP不能进行登录，IP黑名单)")
    @TableField("IP_ADDRESS_")
    private String ipAddress;

    @ApiModelProperty(value = "AK系统访问key")
    @TableField("ACCESS_KEY_")
    private String accessKey;

    @ApiModelProperty(value = "SK安全密钥")
    @TableField("SECRET_KEY_")
    private String secretKey;

    @ApiModelProperty(value = "最后登录时间")
    @TableField("LOGIN_TIME_")
    private LocalDateTime loginTime;

}
