package com.artfess.cgpt.sso.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.CertificateException;
import com.artfess.base.jwt.JwtAuthenticationResponse;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.service.LoginLogService;
import com.artfess.base.service.LoginUserService;
import com.artfess.base.util.*;
import com.artfess.cgpt.sso.manager.SsoSystemManager;
import com.artfess.cgpt.sso.model.SsoSystem;
import com.artfess.cgpt.sso.vo.AuthVO;
import com.artfess.cgpt.sso.vo.BizSsoAuthVO;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

/**
 * 单点登录系统配置 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-12-02
 */
@Api(tags = "单点系统配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/ssoSystem/v1/")
public class SsoSystemController extends BaseController<SsoSystemManager, SsoSystem> {

    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    UserDetailsService userDetailsService;
    @Resource
    LoginUserService loginUserService;
    @Resource
    JwtConfig jwtConfig;
    @Autowired
    SsoSystemManager ssoSystemManager;
    @Resource
    SaaSConfig saasConfig;
    @Resource
    LoginLogService loginLogService;

    @PostMapping("/saveEntity")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> saveEntity(@ApiParam(name="model", value="实体信息") @RequestBody SsoSystem ssoSystem) throws Exception{
        boolean result = baseService.insertSsoSystem(ssoSystem);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody SsoSystem ssoSystem) {
        boolean result = baseService.updateSsoSystem(ssoSystem);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @RequestMapping(value = "/getTokenOfSso", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取token", httpMethod = "POST", notes = "获取token")
    public ResponseEntity<?> getTokenOfSso(@RequestBody BizSsoAuthVO ssoAuthVO) throws AuthenticationException, CertificateException {
        HttpServletRequest request = HttpUtil.getRequest();

        QueryWrapper<SsoSystem> ssoSystemWrapper = new QueryWrapper<>();
        ssoSystemWrapper.eq("ACCESS_KEY_",ssoAuthVO.getAccessKey())
                .eq("SECRET_KEY_",ssoAuthVO.getSecretKey()).last("limit 1");
        SsoSystem ssoSystem = baseService.getBaseMapper().selectOne(ssoSystemWrapper);
        if(BeanUtils.isEmpty(ssoSystem)){
            throw new BaseException("用户不存在或授权过期，请联系管理员");
        }
        if(ssoSystem.getIsIpAstrict()==1){
            if(BeanUtils.isNotEmpty(ssoSystem.getIpAddress()) && ssoSystem.getIpAddress().equals(IPUtils.getIpAddr(request))){
                throw new BaseException("用户不存在或授权过期，请联系管理员");
            }
        }

        HttpSession session = request.getSession();
        final UserDetails USER_DETAILS = userDetailsService.loadUserByUsername("admin");
        final String TOKEN = jwtTokenHandler.generateToken(USER_DETAILS);

        String userName = USER_DETAILS.getUsername();
        String account = "";
        String userId = "";
        boolean loginStatus = true;
        Map<String, Object> userAttrs = new HashMap<String, Object>();
        if (USER_DETAILS instanceof IUser) {
            IUser user = ((IUser) USER_DETAILS);
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            request.setAttribute("loginUser", String.format("%s[%s]", userName, account));
            userAttrs.put("tenantId", user.getTenantId());
        }

        //处理单用户登录
//        handleSingleLogin(false, MapUtil.getString(userAttrs, "tenantId"), account, token);
        //删除登录错误次数
        session.removeAttribute("_loginTime_");
        //修改登录时间
        loginUserService.updateLastLoginTime(account);
        //loginUserService.updateUserIp();
        return ResponseEntity.ok(new JwtAuthenticationResponse(TOKEN, userName, account, userId, jwtConfig.getExpirationLong(), loginStatus, userAttrs));
    }

    @RequestMapping(value = "/authentication", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "第三方系统认证", httpMethod = "POST", notes = "authVO")
    public CommonResult externalSystemAuth(@RequestBody AuthVO authVO) throws Exception{
        if(BeanUtils.isEmpty(authVO.getSysCode())) return new CommonResult("系统编码不能为空");
        if(BeanUtils.isEmpty(authVO.getKey())) return new CommonResult("密匙不能为空");
        //1.判断传过来的系统编码是否存在
        QueryWrapper<SsoSystem> ssoSystemQW = new QueryWrapper<>();
        ssoSystemQW.eq("SYS_CODE_",authVO.getSysCode()).last("limit 1");
        SsoSystem data = ssoSystemManager.getBaseMapper().selectOne(ssoSystemQW);
        if(BeanUtils.isEmpty(data)) return new CommonResult(false,"系统配置不存在");

        //2.系统编码+ak+sk进行md5加密后的密匙与传过来的密匙进行比较
        if(BeanUtils.isEmpty(data.getAccessKey())||BeanUtils.isEmpty(data.getSecretKey())) return new CommonResult(false,"认证失败");
        String str = data.getSysCode()+data.getAccessKey()+data.getSecretKey();
        String curKey = EncryptUtil.md5Hex(str);

        if(curKey.equalsIgnoreCase(authVO.getKey())){
            //如果这条密匙与传入的密匙相等
            HttpServletRequest request = HttpUtil.getRequest();
            HttpSession session = request.getSession();
            String IP = IPUtils.getIpAddr(request);
            boolean isMobile = HttpUtil.isMobile(request);
            //判断请求IP是否是该配置的限制IP
            if(BeanUtils.isNotEmpty(data.getIsIpAstrict())){
                if(data.getIsIpAstrict()==1 && BeanUtils.isNotEmpty(data.getIpAddress())){
                    if(IP.equals(data.getIpAddress())) return new CommonResult(false,"认证失败");
                }
            }
            final UserDetails USER_DETAILS = userDetailsService.loadUserByUsername(data.getSysCode());
            final String TOKEN = jwtTokenHandler.generateToken(USER_DETAILS);
            return new CommonResult(true,"认证成功",TOKEN);
        }
        return new CommonResult(false,"认证失败");
    }


    /**
     * 处理单用户登录
     *
     * @param isMobile
     * @param username
     * @param token
     */
    private void handleSingleLogin(boolean isMobile, String tenantId, String username, String token) {
        String userAgent = isMobile ? "mobile" : "pc";
        //如果是单用户登录
        if (jwtConfig.isSingle()) {
            // 非SaaS模式
            if (StringUtil.isEmpty(tenantId) && !saasConfig.isEnable()) {
                tenantId = "-1";
            }
            // 以当前登录设备、租户ID、用户账号为key将token存放到缓存中
            jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, jwtConfig.getExpiration(), token);
        }else{
            HttpServletRequest request = HttpUtil.getRequest();
            String IP = IPUtils.getIpAddr(request);
            jwtTokenHandler.putTokenInCache(userAgent, tenantId, username,IP, jwtConfig.getExpiration(), token);
        }
        //处理用户登录日志
        loginLogService.log(username, isMobile ? "mobile" : "pc");
    }




}
