package com.artfess.cgpt.receipt.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 对账单明细表
 *
 * @Dept 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizReconciliationDetail对象", description="对账单明细表")
@TableName("biz_reconciliation_detail")
@Data
public class BizReconciliationDetail extends BizNoModel<BizReconciliationDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "对账单ID（关联对账单表ID）")
    @TableField("REC_ID_")
    private String recId;

    @ApiModelProperty(value = "对账单号")
    @TableField("REC_CODE_")
    private String recCode;

    @ApiModelProperty(value = "收货单单ID")
    @TableField("RECEIPT_ID_")
    private String receiptId;

    @ApiModelProperty(value = "收货单明细ID")
    @TableField("RECEIPT_DETAIL_ID_")
    private String receiptDetailId;

    @ApiModelProperty(value = "对账类型（1：招标服务费，2：结算服务费，3：没收保证金，默认1）")
    @TableField("REC_TYPE_")
    private Integer recType;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项明细ID")
    @TableField("NOTICE_DETAIL_ID_")
    private String noticeDetailId;

    @ApiModelProperty(value = "物料ID（关联企业物料表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLAT_CODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类")
    @TableField("MAT_CATEGORY_")
    private String matCategory;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "数量")
    @TableField("ISD_QUANTITY_")
    private BigDecimal isdQuantity;

    @ApiModelProperty(value = "单价")
    @TableField("ISD_PRICE_")
    private BigDecimal isdPrice;

    @ApiModelProperty(value = "金额")
    @TableField("ISD_AMOUNT_")
    private BigDecimal isdAmount;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    @TableField("TAX_VALUE_")
    private BigDecimal taxValue;

    @ApiModelProperty(value = "含税单价")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税金额")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "供应商补充说明")
    @TableField("VENDOR_NOTE_")
    private String vendorNote;

    @ApiModelProperty(value = "交货期")
    @TableField("REQ_DATE_")
    private LocalDate reqDate;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("PUR_NOTE_")
    private String purNote;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

    @ApiModelProperty(value = "到货编号")
    @TableField("ARRIVAL_CODE_")
    private String arrivalCode;

    @ApiModelProperty(value = "收货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

}
